﻿using System.Windows;
using System.Windows.Controls;
using FooEditEngine.WPF;

namespace FooEditor
{
    /// <summary>
    /// LineJumpDialog.xaml の相互作用ロジック
    /// </summary>
    public partial class LineJumpDialog : Window
    {
        public LineJumpDialog()
        {
            InitializeComponent();
            this.DataContext = this;
        }

        private FooTextBox _TextBox;

        public int ToRow
        {
            get { return (int)GetValue(ToRowProperty); }
            set { SetValue(ToRowProperty, value); }
        }

        public static readonly DependencyProperty ToRowProperty =
            DependencyProperty.Register("ToRow", typeof(int), typeof(LineJumpDialog), new PropertyMetadata(0));

        public int LineCount
        {
            get { return (int)GetValue(LineCountProperty); }
            set { SetValue(LineCountProperty, value); }
        }

        public static readonly DependencyProperty LineCountProperty =
            DependencyProperty.Register("LineCount", typeof(int), typeof(LineJumpDialog), new PropertyMetadata(0));

        public FooTextBox TextBox
        {
            get
            {
                return this._TextBox;
            }
            set
            {
                this._TextBox = value;
                this.ToRow = this._TextBox.CaretPostion.row + 1;
                this.LineCount = this._TextBox.LayoutLineCollection.Count + 1;
            }
        }

        private void OK_Click(object sender, RoutedEventArgs e)
        {
            var hasErros = Validation.GetErrors(this.JumpToTextBox);
            if (hasErros.Count == 0)
            {
                this.TextBox.JumpCaret(this.ToRow - 1, 0);
                this.TextBox.Refresh();
                this.Close();
            }
        }

        private void Cancle_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
