﻿using System;
using AvalonDock.Layout;

namespace FooEditor.Plugin
{
    public class ExplorerBar<T>
    {
        T _content;
        LayoutAnchorable anchor;
        public ExplorerBar()
        {
            this.anchor = new LayoutAnchorable();
        }
        public T Content
        {
            get
            {
                return this._content;
            }
            set
            {
                this._content = value;
                this.anchor.Content = value;
            }
        }
        public bool IsVisible
        {
            get
            {
                return this.anchor.IsVisible;
            }
            set
            {
                this.anchor.IsVisible = value;
            }
        }
        internal LayoutAnchorable Anchor
        {
            get
            {
                return this.anchor;
            }
        }
    }
    /// <summary>
    /// プラグインインターフェイス
    /// </summary>
    public interface IPlugin
    {
        /// <summary>
        /// 起動時に呼び出されるメソッド
        /// </summary>
        /// <param name="e"></param>
        void Initalize(MainWindow e);
        /// <summary>
        /// 終了時に呼び出されるメソッド
        /// </summary>
        void ClosedApp();
        /// <summary>
        /// 設定ダイアログを表示するときに呼び出されるメソッド
        /// </summary>
        void ShowConfigForm();
    }
}
