﻿using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Windows.Controls;
using System.Windows.Input;
using System.Runtime.CompilerServices;

namespace FooEditor
{
    public class DocumentType : INotifyPropertyChanged
    {
        public string _Extension, _Name;
        public bool _IsActive;
        public string Extension
        {
            get
            {
                return this._Extension;
            }
            set
            {
                this._Extension = value;
                this.OnPropertyChanged();
            }
        }
        public string Name
        {
            get
            {
                return this._Name;
            }
            set
            {
                this._Name = value;
                this.OnPropertyChanged();
            }
        }
        public bool IsActive
        {
            get
            {
                return this._IsActive;
            }
            set
            {
                this._IsActive = value;
                this.OnPropertyChanged();
            }
        }

        public DocumentType(string name, string ext)
        {
            this._Extension = ext;
            this._Name = name;
            this._IsActive = false;
        }

        public void OnPropertyChanged([CallerMemberName] string name = "")
        {
            if(this.PropertyChanged != null)
                this.PropertyChanged(this,new PropertyChangedEventArgs(name));
        }

        public event PropertyChangedEventHandler PropertyChanged;
    }
    public class DocumentTypeCollection : ObservableCollection<DocumentType>
    {
        public DocumentType SelectedItem
        {
            get;
            private set;
        }

        public void Add(string name,string ext)
        {
            base.Add(new DocumentType(name, ext));
        }

        public void Select(string name)
        {
            this.SelectedItem = null;
            for (int i = 0; i < base.Count; i++)
            {
                if (base[i].Name == name)
                {
                    base[i].IsActive = true;
                    this.SelectedItem = base[i];
                }
                else
                    base[i].IsActive = false;
            }
        }
    }
}
