/*
 * JHPdf Free PDF Library : HPdfCIDFontDef.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfTextWidth;
import net.sf.jhpdf.pdfobject.HPdfFont;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;
import net.sf.jhpdf.pdfobject.HPdfXref;

/**
 * Class represents PDF CID Font definition.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public abstract class HPdfCIDFontDef extends HPdfFontDef {
    // TODO only stub, needs methods definition.

    private static final Logger logger = LoggerFactory.getLogger(HPdfCIDFontDef.class);
    
    /* default array size of widths-table of cid-fontdef */
    private static final int HPDF_DEF_CHAR_WIDTHS_NUM = 128;
    
    protected HPdfCIDFontDef(String name) {
        super();
        logger.trace("HPdfCIDFontDef#ctor");
        
        // TODO HPDF_LIMIT_MAX_NAME_LEN check required.
        this.setBaseFont(name);
        
        this.setFontDefType(HPdfFontDefType.UNINITIALIZED);
        this.setValid(false);
        
        this.setMissingWidth(500);
        this.attr.setDw(1000);
        int[] dw2 = this.attr.getDw2();
        dw2[0] = 880;
        dw2[1] = -1000;
    }
    
    protected final void addWidth(HPdfCIDWidth[] widths) {
        logger.trace("HPdfCIDFontDef#addWidth");
        
        for (final HPdfCIDWidth w : widths) {
            if (w.cid == 0xFFFF) {
                break;
            }
            this.getAttr().addWidth(w.clone());
        }
    }
    
    protected final int getCIDWidth(int cid) {
        logger.trace("HPdfCIDFontDef#getCIDWidth");
        
        for (final HPdfCIDWidth w : this.getAttr().getWidths()) {
            if (w.cid == cid) {
                return w.width;
            }
        }
        /* Not found in pdf_cid_width list. */
        return this.getAttr().getDw();
    }

    @Override
    public int getWidth(char code) {
        // TODO ꂽ\bhEX^u
        
        return 0;
    }
    
    protected final void changeStyle(boolean bold, boolean italic) {
        logger.trace("HPdfCIDFontDef#getCIDWidth");
        
        if (this.getAttr() == null) {
            throw new HPdfException(HPdfErrorCode.HPDF_INVALID_FONTDEF_DATA, 0);
        }
        
        if (bold) {
            this.setStemv(this.getStemv() * 2);
            this.setFlag(HPDF_FONT_FOURCE_BOLD);
        }
        
        if (italic) {
            this.setItalicAngle(-11);
            this.setFlag(HPDF_FONT_ITALIC);
        }
    }
    
    protected final class HPdfCIDWidth implements Cloneable {

        private int cid;
        int getCID() {
            return this.cid;
        }
        
        private int width;
        int getWidth() {
            return this.width;
        }
        
        protected HPdfCIDWidth clone() {
            HPdfCIDWidth o;
            try {
                o = (HPdfCIDWidth) super.clone();
            } catch (CloneNotSupportedException e) {
                throw new RuntimeException("HPdfCIDWidth cloning failed", e);
            }
            o.cid = this.cid;
            o.width = this.width;
            return o;
        }
    }
    
    private HPdfCIDFontDefAttr attr = new HPdfCIDFontDefAttr();
    
    protected HPdfCIDFontDefAttr getAttr() {
        return this.attr;
    }
    
    int getDw() {
        return attr.getDw();
    }
    
    int[] getDw2() {
        return attr.getDw2();
    }
    
    List<HPdfCIDWidth> getWidths() {
        return attr.getWidths();
    }
    
    private final class HPdfCIDFontDefAttr {
        
        private List<HPdfCIDWidth> widths = new ArrayList<HPdfCIDWidth>();
        
        private List<HPdfCIDWidth> getWidths() {
            return this.widths;
        }
        
        private void addWidth(HPdfCIDWidth width) {
            this.widths.add(width);
        }
        
        private int dw;
        
        private int getDw() {
            return this.dw;
        }
        
        private void setDw(int dw) {
            this.dw = dw;
        }
        
        private int[] dw2 = new int[2];
        
        private int[] getDw2() {
            // TODO should return clone?
            return this.dw2;
        }
    }
    
    
}
