/*
 * JHPdf Free PDF Library : HPdfLinkAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.pdfobject.HPdfDestination;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.graphics.HPdfRect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Link Annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfLinkAnnotation extends HPdfAbstractLinkAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdfLinkAnnotation.class);

    public enum HPdfHighlightMode {
        NO_HIGHTLIGHT("N"),
        INVERT_BOX(""), // default mode, so has no code
        INVERT_BORDER("O"),
        DOWN_APPEARANCE("P"),
        ;
        private String code;
        HPdfHighlightMode(String code) {
            this.code = code;
        }
        public String getCode() {
            return this.code;
        }
    }
    
    public HPdfLinkAnnotation(HPdfXref xref, HPdfRect rect, HPdfDestination dst) {
        super(xref, rect);
        
        logger.trace("HPdfLinkAnnotation#ctor");
        
        this.add("Dest", dst);
    }

}

