/*
 * JHPdf Free PDF Library : HPdf3DAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.pdfobject.HPdfAnnotation;
import net.sf.jhpdf.pdfobject.HPdfBoolean;
import net.sf.jhpdf.pdfobject.HPdfDict;
import net.sf.jhpdf.pdfobject.HPdfString;
import net.sf.jhpdf.pdfobject.HPdfU3D;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.graphics.HPdfRect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Link Annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdf3DAnnotation extends HPdfAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdf3DAnnotation.class);
    
    public HPdf3DAnnotation(HPdfXref xref, HPdfRect rect, HPdfU3D u3d) {
        super(xref, rect);
        
        logger.trace("HPdf3DAnnotation#ctor");
        
        this.addName("SubType", "3D");
        
        this.add("Contents", new HPdfString("3D Model", null));
        
        HPdfDict action = new HPdfDict();
        
        this.add("3DA", action);
        
        action.addName("A", "PV");
        
        action.addBoolean("TB", false);
        
        this.add("3DD", u3d);
        
        HPdfDict appearance = new HPdfDict();
        
        this.add("AP", appearance);
        
        HPdfDict stream = new HPdfDict();
        
        appearance.add("N", stream);
    }
    
    public void set3DView() {
        logger.trace("HPdf3DAnnotation#set3DView");
        
        this.validate();
        
        this.add("3DD", new HPdfBoolean(false));
        
    }

}
