/*
 * JHPdf Free PDF Library : HPdfFilterableDict.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import java.util.EnumSet;

import net.sf.jhpdf.io.HPdfStream.HPdfFilterFlag;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Dictionary with filter.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public abstract class HPdfFilterableDict extends HPdfDict {

    private static final Logger logger = LoggerFactory.getLogger(HPdfFilterableDict.class);
    
    private EnumSet<HPdfFilterFlag> filter =
            EnumSet.noneOf(HPdfFilterFlag.class);
    
    private HPdfDict filterParams;
    
    /**
     * ctor.
     */
    protected HPdfFilterableDict() {
        super();
    }
    
    public EnumSet<HPdfFilterFlag> getFilterSet() {
        return this.filter;
    }
    
    public void setFilterSet(EnumSet<HPdfFilterFlag> filterSet) {
        this.filter = filterSet;
    }
    
    public void setFilter(HPdfFilterFlag filter) {
        this.filter.add(filter);
    }
    
    public void resetFilter(HPdfFilterFlag filter) {
        this.filter.remove(filter);
    }
    
    protected HPdfDict getFilterParams() {
        return this.filterParams;
    }
    
    protected void setFilterParams(HPdfDict filterParams) {
        this.filterParams = filterParams;
    }

}
