/*
 * JHPdf Free PDF Library : HPdfIoException.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.io;

import net.sf.jhpdf.HPdfException;

/**
 * Exception class represents errors related to I/O.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfIoException extends HPdfException {
    
    /**
     * default serialization ID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * ctor.
     * @param errorNo major error number.(corresponds libHaru's one.)
     * @param detailNo minor error number.(corresponds libHaru's one.)
     */
    public HPdfIoException(int errorNo, int detailNo) {
        super(errorNo, detailNo);
    }
    
    /**
     * ctor with a cause Exception.
     * @param errorNo major error number.(corresponds libHaru's one.)
     * @param detailNo minor error number.(corresponds libHaru's one.)
     * @param cause the cause of this error.
     */
    public HPdfIoException(int errorNo, int detailNo, Throwable cause) {
        super(errorNo, detailNo, cause);
    }
    
    /**
     * @see HPdfException#createMessage().
     * @return human-readable error message.
     */
    @Override
    protected String createMessage() {
        return String.format("IO ERROR: error_no=%04X, detail_no=%d",
            getErrorNo(), getDetailNo() );
    }
}
