/*
 * JHPdf Free PDF Library : HPdfDashMode.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.graphics;

/**
 * Class represents PDF dash mode.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfDashMode implements Cloneable {
    
    private int[] ptn;
    private int phase;
    
    public HPdfDashMode() {
        super();
        
        setPattern(new int[0], 0, 0);
    }
    
    public void setPattern(int[] ptn, int numPtn, int phase) {
        this.ptn = new int[numPtn];
        if (numPtn > 0) {
            System.arraycopy(this.ptn, 0, ptn, 0, numPtn);
        }
        this.phase = phase;
    }
    
    public int getNumPtn() {
        return this.ptn.length;
    }
    
    private void copy(HPdfDashMode org) {
        this.setPattern(org.ptn, org.getNumPtn(), org.phase);
    }

    @Override
    public HPdfDashMode clone()  {
        HPdfDashMode o;
        try {
            o = (HPdfDashMode) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException("HPdfDashMode cloning failed", e);
        }
        o.copy(this);
        return o;
    }    
    
}
