/*
 * JHPdf Free PDF Library : TextAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.annotation.HPdfTextAnnotation;
import net.sf.jhpdf.pdfobject.annotation.HPdfTextAnnotation.HPdfAnnotIcon;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.*;


public class TextAnnotation implements DemoEntry {
    public static void main(String[] args) {
        new TextAnnotation().demo(args);
    }
    
    private static final String F_NAME = "TextAnnotation.pdf";
    
    @Override
    public void demo(String[] args) {
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* use Times-Roman font. */
            HPdfFont font = pdf.getFont("Times-Roman", "WinAnsiEncoding");
            
            HPdfPage page = pdf.addPage();
            
            page.setWidth(400);
            page.setHeight(500);
            
            page.beginText();
            page.setFontAndSize(font, 16);
            page.moveTextPos(130, 450);
            page.showText("Annotation Demo");
            page.endText();
            
            
            HPdfRect rect1 = new HPdfRect(50, 350, 150, 400);
            HPdfTextAnnotation annot = page.createTextAnnot(rect1, "Annotation with Comment "
                + "Icon. \n This annotation set to be opened initially.",
                null);
            
            annot.setIcon(HPdfAnnotIcon.COMMENT);
            annot.setOpened(true);
            
            HPdfRect rect2 = new HPdfRect(210, 350, 350, 400);
            annot = page.createTextAnnot(rect2,
                "Annotation with Key Icon", null);
            annot.setIcon(HPdfAnnotIcon.PARAGRAPH);
            
            HPdfRect rect3 = new HPdfRect(50, 250, 150, 300);
            annot = page.createTextAnnot(rect3,
                "Annotation with Note Icon", null);
            annot.setIcon(HPdfAnnotIcon.NOTE);
            
            HPdfRect rect4 = new HPdfRect(210, 250, 350, 300);
            annot = page.createTextAnnot(rect4,
                "Annotation with Help Icon", null);
            annot.setIcon(HPdfAnnotIcon.HELP);
            
            HPdfRect rect5 = new HPdfRect(50, 150, 150, 200);
            annot = page.createTextAnnot(rect5,
                "Annotation with NewParagraph Icon", null);
            annot.setIcon(HPdfAnnotIcon.NEW_PARAGRAPH);
            
            HPdfRect rect6 = new HPdfRect(210, 150, 350, 200);
            annot = page.createTextAnnot(rect6,
                "Annotation with Paragraph Icon", null);
            annot.setIcon(HPdfAnnotIcon.PARAGRAPH);
            
            HPdfRect rect7 = new HPdfRect(50, 50, 150, 100);
            annot = page.createTextAnnot(rect7,
                "Annotation with Insert Icon", null);
            annot.setIcon(HPdfAnnotIcon.INSERT);
            
            HPdfEncoder encoding = pdf.getEncoder("ISO8859-2");
            
            HPdfRect rect8 = new HPdfRect(210, 50, 350, 100);
            annot = page.createTextAnnot(rect7,
                new String("Annotation with ISO8859 text \u00D3\u00D4\u00D5\u00D6\u00D7\u00D8\u00D9".getBytes("ISO-8859-1"), "ISO-8859-2"),
                encoding);
            
            page.setFontAndSize(font, 11);
            
            page.beginText();
            page.moveTextPos(rect1.getLeft() + 35, rect1.getTop() - 20);
            page.showText("Comment Icon.");
            page.endText();

            page.beginText();
            page.moveTextPos(rect2.getLeft() + 35, rect2.getTop() - 20);
            page.showText("Key Icon");
            page.endText();

            page.beginText();
            page.moveTextPos(rect3.getLeft() + 35, rect3.getTop() - 20);
            page.showText("Note Icon.");
            page.endText();

            page.beginText();
            page.moveTextPos(rect4.getLeft() + 35, rect4.getTop() - 20);
            page.showText("Help Icon");
            page.endText();

            page.beginText();
            page.moveTextPos(rect5.getLeft() + 35, rect5.getTop() - 20);
            page.showText("NewParagraph Icon");
            page.endText();

            page.beginText();
            page.moveTextPos(rect6.getLeft() + 35, rect6.getTop() - 20);
            page.showText("Paragraph Icon");
            page.endText();

            page.beginText();
            page.moveTextPos(rect7.getLeft() + 35, rect7.getTop() - 20);
            page.showText("Insert Icon");
            page.endText();

            page.beginText();
            page.moveTextPos(rect8.getLeft() + 35, rect8.getTop() - 20);
            page.showText("Text Icon(ISO8859-2 text)");
            page.endText();
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }

}
