/*
 * JHPdf Free PDF Library : TTFontDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/character_map.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;


public class TTFontDemo implements DemoEntry {
    public static void main(String[] args) {
        new TTFontDemo().demo(args);
    }
    
    private static final String F_NAME = "TTFontDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        final String SAMP_TXT = "The quick brown fox jumps over the lazy dog.";
        
        if (args.length < 2) {
            System.out.println("usage: java TTFontDemo [path to font file] -E(embedding font).");
            return;
        }
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* Add a new page object. */
            HPdfPage page = pdf.addPage();
            
            HPdfFont titleFont = pdf.getFont("Helvetica", null);
            
            boolean embed;
            if (args.length > 2 && args[1].equals("-E")) {
                embed = true;
            } else {
                embed = false;
            }
            
            String detailFontName = pdf.loadTTFontFromFile(args[0], embed);
            
            HPdfFont detailFont = pdf.getFont(detailFontName, null);
            
            page.setFontAndSize(titleFont, 10);
            
            page.beginText();
            
            /* Move the position of the text to top of the page. */
            page.moveTextPos(10, 190);
            page.showText(detailFontName);
            if (embed) {
                page.showText("(Embedded Subset)");
            }
            
            page.setFontAndSize(detailFont, 15);
            page.moveTextPos(10, -20);
            page.showText("abcdefghijklmnopqrstuvwxyz");
            page.moveTextPos(0, -20);
            page.showText("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            page.moveTextPos(0, -20);
            page.showText("1234567890");
            page.moveTextPos(0, -20);

            page.setFontAndSize(detailFont, 10);
            page.showText(SAMP_TXT);
            page.moveTextPos(0, -18);

            page.setFontAndSize(detailFont, 16);
            page.showText(SAMP_TXT);
            page.moveTextPos(0, -27);

            page.setFontAndSize(detailFont, 23);
            page.showText(SAMP_TXT);
            page.moveTextPos(0, -36);

            page.setFontAndSize(detailFont, 30);
            page.showText(SAMP_TXT);
            page.moveTextPos(0, -36);

            float pw = page.textWidth(SAMP_TXT);
            float page_height = 210;
            float page_width = pw + 40;

            page.setWidth(page_width);
            page.setHeight(page_height);

            /* Finish to print text. */
            page.endText();

            page.setLineWidth(0.5F);

            page.moveTo(10, page_height - 25);
            page.lineTo(page_width - 10, page_height - 25);
            page.stroke();

            page.moveTo(10, page_height - 85);
            page.lineTo(page_width - 10, page_height - 85);
            page.stroke();
            
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
}
