/*
 * JHPdf Free PDF Library : RawImageDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.io.File;

import net.sf.jhpdf.*;
import net.sf.jhpdf.graphics.HPdfColorSpace;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfDocument.HPdfCompressionMode;


public class RawImageDemo  implements DemoEntry {
    public static void main(String[] args) {
        new RawImageDemo().demo(args);
    }
    
    private static final String F_NAME = "RawImageDemo.pdf";
    
    private static final byte[] RAW_IMAGE_DATA = {
        (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xfe, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xfc,
        (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xf8, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xf0,
        (byte) 0xf3, (byte) 0xf3, (byte) 0xff, (byte) 0xe0, (byte) 0xf3, (byte) 0xf3, (byte) 0xff, (byte) 0xc0,
        (byte) 0xf3, (byte) 0xf3, (byte) 0xff, (byte) 0x80, (byte) 0xf3, (byte) 0x33, (byte) 0xff, (byte) 0x00,
        (byte) 0xf3, (byte) 0x33, (byte) 0xfe, (byte) 0x00, (byte) 0xf3, (byte) 0x33, (byte) 0xfc, (byte) 0x00,
        (byte) 0xf8, (byte) 0x07, (byte) 0xf8, (byte) 0x00, (byte) 0xf8, (byte) 0x07, (byte) 0xf0, (byte) 0x00,
        (byte) 0xfc, (byte) 0xcf, (byte) 0xe0, (byte) 0x00, (byte) 0xfc, (byte) 0xcf, (byte) 0xc0, (byte) 0x00,
        (byte) 0xff, (byte) 0xff, (byte) 0x80, (byte) 0x00, (byte) 0xff, (byte) 0xff, (byte) 0x00, (byte) 0x00,
        (byte) 0xff, (byte) 0xfe, (byte) 0x00, (byte) 0x00, (byte) 0xff, (byte) 0xfc, (byte) 0x00, (byte) 0x00,
        (byte) 0xff, (byte) 0xf8, (byte) 0x0f, (byte) 0xe0, (byte) 0xff, (byte) 0xf0, (byte) 0x0f, (byte) 0xe0,
        (byte) 0xff, (byte) 0xe0, (byte) 0x0c, (byte) 0x30, (byte) 0xff, (byte) 0xc0, (byte) 0x0c, (byte) 0x30,
        (byte) 0xff, (byte) 0x80, (byte) 0x0f, (byte) 0xe0, (byte) 0xff, (byte) 0x00, (byte) 0x0f, (byte) 0xe0,
        (byte) 0xfe, (byte) 0x00, (byte) 0x0c, (byte) 0x30, (byte) 0xfc, (byte) 0x00, (byte) 0x0c, (byte) 0x30,
        (byte) 0xf8, (byte) 0x00, (byte) 0x0f, (byte) 0xe0, (byte) 0xf0, (byte) 0x00, (byte) 0x0f, (byte) 0xe0,
        (byte) 0xe0, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0xc0, (byte) 0x00, (byte) 0x00, (byte) 0x00,
        (byte) 0x80, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00
    };
    
    @Override
    public void demo(String[] args) {
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            pdf.setCompressionMode(HPdfCompressionMode.ALL);
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            
            page.setWidth(172);
            page.setHeight(80);
            
            page.beginText();
            page.setFontAndSize(font, 20);
            page.moveTextPos(220, page.getHeight() - 70);
            page.showText("RawImageDemo");
            page.endText();
            
            /* load RGB raw-image file. */
            HPdfImage image = pdf.loadRawImageFromFile("rawimage" + File.separator + "32_32_rgb.dat",
                32, 32, HPdfColorSpace.DEVICE_RGB);
            
            float x = 20;
            float y = 20;
            
            /* Draw image to the canvas. (normal-mode with actual size.)*/
            page.drawImage(image, x, y, 32, 32);
            
            /* load GrayScale raw-image file. */
            image = pdf.loadRawImageFromFile("rawimage" + File.separator + "32_32_gray.dat",
                32, 32, HPdfColorSpace.DEVICE_GRAY);
            
            x = 70;
            y = 20;
            
            /* Draw image to the canvas. (normal-mode with actual size.)*/
            page.drawImage(image, x, y, 32, 32);
            
            /* load GrayScale raw-image (1bit) file from memory. */
            image = pdf.loadRawImageFromMem(RAW_IMAGE_DATA, 32, 32,
                HPdfColorSpace.DEVICE_GRAY, 1);
            
            x = 120;
            y = 20;
            
            /* Draw image to the canvas. (normal-mode with actual size.)*/
            page.drawImage(image, x, y, 32, 32);
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
}
