/*
 * JHPdf Free PDF Library : Permission.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/attach.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.encrypt.HPdfEncrypt.HPdfPdfPermission;
import net.sf.jhpdf.encrypt.HPdfEncrypt.HPdfEncryptMode;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfPageSizes;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfPageDirection;


public class Permission implements DemoEntry {
    public static void main(String[] args) {
        new Permission().demo(args);
    }
    
    private static final String F_NAME = "Permission.pdf";
    
    private static final String text = "User cannot print and copy this document.";
    private static final String ownerPasswd = "owner";
    private static final String userPasswd = "";
    
    @Override
    public void demo(String[] args) {
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);

            /* add a new page object. */
            HPdfPage page = pdf.addPage();

            page.setSize(HPdfPageSizes.B5, HPdfPageDirection.LANDSCAPE);

            page.beginText();
            page.setFontAndSize(font, 20);
            float tw = page.textWidth(text);
            page.moveTextPos((page.getWidth() - tw) / 2,
                       (page.getHeight()  - 20) / 2);
            page.showText(text);
            page.endText();

            pdf.setPassword(ownerPasswd, userPasswd);
            pdf.setPermission(HPdfPdfPermission.READ);
            pdf.setEncryptionMode(HPdfEncryptMode.R3, 16);
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }

}
