/*
 * JHPdf Free PDF Library : OutlineDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfCatalog.HPdfPageMode;


public class OutlineDemo  implements DemoEntry {
    public static void main(String[] args) {
        new OutlineDemo().demo(args);
    }
    
    private static final String F_NAME = "OutlineDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);
            
            /* Set page mode to use outlines. */
            pdf.setPageMode(HPdfPageMode.USE_OUTLINE);
            
            /* Add 3 pages to the document. */
            HPdfPage[] page = new HPdfPage[3];
            page[0] = pdf.addPage();
            page[0].setFontAndSize(font, 30);
            printPage(page[0], 1);
            
            page[1] = pdf.addPage();
            page[1].setFontAndSize(font, 30);
            printPage(page[1], 2);
            
            page[2] = pdf.addPage();
            page[2].setFontAndSize(font, 30);
            printPage(page[2], 3);
            
            /* create outline root. */
            HPdfOutline root = pdf.createOutline(null, "OutlineRoot", null);
            root.setOpened(true);
            
            HPdfOutline[] outline = new HPdfOutline[4];
            outline[0] = pdf.createOutline(root, "page1", null);
            outline[1] = pdf.createOutline(root, "page2", null);
            
            /* create outline with test which is ISO8859-2 encoding */
            outline[2] = pdf.createOutline(root, 
                new String("ISO8859-2 text \u00D3\u00D4\u00D5\u00D6\u00D7\u00D8\u00D9".getBytes("ISO-8859-1"), "ISO-8859-2"),
                pdf.getEncoder("ISO8859-2"));
            
            /* create destination objects on each pages
             * and link it to outline items.
             */
            HPdfDestination dst = page[0].createDestination();
            dst.setXYZ(0, page[0].getHeight(), 1);
            outline[0].setDestination(dst);
            
            dst = page[1].createDestination();
            dst.setXYZ(0, page[1].getHeight(), 1);
            outline[1].setDestination(dst);
            
            dst = page[2].createDestination();
            dst.setXYZ(0, page[2].getHeight(), 1);
            outline[2].setDestination(dst);
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    private void printPage(HPdfPage page, int pageNum) {
        
        page.setWidth(800);
        page.setHeight(800);
        
        page.beginText();
        page.moveTextPos(30, 740);
        page.showText(String.format("Page:%d", pageNum));
        page.endText();
    }
    
}
