/*
 * JHPdf Free PDF Library : MakeRawImage.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.io.HPdfFileWriteStream;
import net.sf.jhpdf.io.HPdfStream.HPdfFilterFlag;
import net.sf.jhpdf.io.HPdfWriteStream;
import net.sf.jhpdf.pdfobject.*;


public class MakeRawImage  implements DemoEntry{
    public static void main(String[] args) {
        new MakeRawImage().demo(args);
    }
    
    @Override
    public void demo(String[] args) {
        
        if (args.length < 2) {
            System.out.println("usage: java MakeRawImage <in-file-name> <out-file-name>");
            return;
        }
        
        HPdfWriteStream stream = null;
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* load image file. */
            HPdfImage image = pdf.loadPngImageFromFile(args[0]);
            
            int iw = image.getWidth();
            int ih = image.getHeight();
            int bitsPerComp = image.getBitsPerComponent();
            String cs = image.getColorSpace();
            
            System.out.println("width=" + iw);
            System.out.println("height=" + ih);
            System.out.println("bits_per_comp=" + bitsPerComp);
            System.out.println("color_space=" + cs);
            
            /* save raw-data to file */
            stream = new HPdfFileWriteStream(args[1]);
            image.getStreamForRead().writeToStream(stream, HPdfFilterFlag.NONE, null);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
    }
    
}
