/*
 * JHPdf Free PDF Library : LineDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.graphics.*;


public class LineDemo implements DemoEntry {
    public static void main(String[] args) {
        new LineDemo().demo(args);
    }
    
    private static final String F_NAME = "LineDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        String pageTitle = "Line Example";
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            
            /* print the lines of the page. */
            page.setLineWidth(1);
            page.rectangle(50, 50, page.getWidth() - 100,
                page.getHeight() - 110);
            page.stroke();
            
            /* print the title of the page (with positioning center). */
            page.setFontAndSize(font, 24);
            float tw = page.textWidth(pageTitle);
            page.beginText();
            page.moveTextPos((page.getWidth() - tw) / 2, page.getHeight() - 50);
            page.showText(pageTitle);
            page.endText();
            
            /* Draw verious widths of lines. */
            page.setLineWidth(0);
            drawLine(page, 60, 770, "line width = 0");
            
            page.setLineWidth(1.0F);
            drawLine(page, 60, 740, "line width = 1.0");
            
            page.setLineWidth(2.0F);
            drawLine(page, 60, 710, "line width = 2.0");
            
            /* Line dash pattern */
            page.setLineWidth(1.0F);
            
            int[] DASH_MODE1 = {3};
            int[] DASH_MODE2 = {3, 7};
            int[] DASH_MODE3 = {8, 7, 2, 7};
            
            page.setDash(DASH_MODE1, 1);
            drawLine(page, 60, 680, "dash_ptn=[3], phase=1 -- "
                 + "2 on, 3 off, 3 on...");
            
            page.setDash(DASH_MODE2, 2);
            drawLine(page, 60, 650, "dash_ptn=[7, 3], phase=2 -- "
                 + "5 on, 3 off, 7 on...");
            
            page.setDash(DASH_MODE3, 0);
            drawLine(page, 60, 620, "dash_ptn=[8, 7, 2, 7], phase=0");
            
            page.setDash(null, 0);
            
            page.setLineWidth(30);
            page.setRGBStroke(0.0F, 0.5F, 0.0F);
            
            /* Line Cap Style */
            page.setLineCap(HPdfLineCap.BUTT_END);
            drawLine2(page, 60, 570, "PDF_BUTT_END");
            
            page.setLineCap(HPdfLineCap.ROUND_END);
            drawLine2(page, 60, 505, "PDF_ROUND_END");
            
            page.setLineCap(HPdfLineCap.PROJECTING_SCUARE_END);
            drawLine2(page, 60, 440, "PDF_PROJECTING_SCUARE_END");
            
            /* Line Join Style */
            page.setLineWidth(30);
            page.setRGBStroke(0.0F, 0.0F, 0.5F);
            
            page.setLineJoin(HPdfLineJoin.MITER_JOIN);
            page.moveTo(120, 300);
            page.lineTo(160, 340);
            page.lineTo(200, 300);
            page.stroke();
            
            page.beginText();
            page.moveTextPos(60, 360);
            page.showText("PDF_MITER_JOIN");
            page.endText();
            
            page.setLineJoin(HPdfLineJoin.ROUND_JOIN);
            page.moveTo(120, 195);
            page.lineTo(160, 235);
            page.lineTo(200, 195);
            page.stroke();
            
            page.beginText();
            page.moveTextPos(60, 255);
            page.showText("PDF_ROUND_JOIN");
            page.endText();
            
            page.setLineJoin(HPdfLineJoin.BEVEL_JOIN);
            page.moveTo(120, 90);
            page.lineTo(160, 130);
            page.lineTo(200, 90);
            page.stroke();
            
            page.beginText();
            page.moveTextPos(60, 150);
            page.showText("PDF_BEVEL_JOIN");
            page.endText();
            
            /* Draw Rectangle */
            page.setLineWidth(2);
            page.setRGBStroke(0.0F, 0.0F, 0.0F);
            page.setRGBFill(0.75F, 0.0F, 0.0F);
            
            drawRect(page, 300, 770, "Stroke");
            page.stroke();
            
            drawRect(page, 300, 720, "Fill");
            page.fill();
            
            drawRect(page, 300, 670, "Fill then Stroke");
            page.fillStroke();
            
            /* Clip Rect */
            page.gSave(); /* Save the current graphic state */
            drawRect(page, 300, 620, "Clip Rectangle");
            page.clip();
            page.stroke();
            page.setFontAndSize(font, 13);
            
            page.beginText();
            page.moveTextPos(290, 600);
            page.setTextLeading(12);
            page.showText(
                        "Clip Clip Clip Clip Clip Clipi Clip Clip Clip");
            page.showTextNextLine(
                        "Clip Clip Clip Clip Clip Clip Clip Clip Clip");
            page.showTextNextLine(
                        "Clip Clip Clip Clip Clip Clip Clip Clip Clip");
            page.endText();
            page.gRestore();
            
            /* Curve Example(CurveTo2) */
            float x = 330;
            float y = 440;
            float x1 = 430;
            float y1 = 530;
            float x2 = 480;
            float y2 = 470;
            float x3 = 480;
            float y3 = 90;

            page.setRGBFill(0, 0, 0);

            page.beginText();
            page.moveTextPos(300, 540);
            page.showText("CurveTo2(x1, y1, x2. y2)");
            page.endText();

            page.beginText();
            page.moveTextPos(x + 5, y - 5);
            page.showText("Current point");
            page.moveTextPos(x1 - x, y1 - y);
            page.showText("(x1, y1)");
            page.moveTextPos(x2 - x1, y2 - y1);
            page.showText("(x2, y2)");
            page.endText();

            page.setDash(DASH_MODE1, 0);

            page.setLineWidth(0.5F);
            page.moveTo(x1, y1);
            page.lineTo(x2, y2);
            page.stroke();

            page.setDash(null, 0);

            page.setLineWidth(1.5F);

            page.moveTo(x, y);
            page.curveTo2(x1, y1, x2, y2);
            page.stroke();

            /* Curve Example(CurveTo3) */
            y -= 150;
            y1 -= 150;
            y2 -= 150;

            page.beginText();
            page.moveTextPos(300, 390);
            page.showText("CurveTo3(x1, y1, x2. y2)");
            page.endText();

            page.beginText();
            page.moveTextPos(x + 5, y - 5);
            page.showText("Current point");
            page.moveTextPos(x1 - x, y1 - y);
            page.showText("(x1, y1)");
            page.moveTextPos(x2 - x1, y2 - y1);
            page.showText("(x2, y2)");
            page.endText();

            page.setDash(DASH_MODE1, 0);

            page.setLineWidth(0.5F);
            page.moveTo(x, y);
            page.lineTo(x1, y1);
            page.stroke();

            page.setDash(null, 0);

            page.setLineWidth(1.5F);
            page.moveTo(x, y);
            page.curveTo3(x1, y1, x2, y2);
            page.stroke();

            /* Curve Example(CurveTo) */
            y -= 150;
            y1 -= 160;
            y2 -= 130;
            x2 += 10;

            page.beginText();
            page.moveTextPos(300, 240);
            page.showText("CurveTo(x1, y1, x2. y2, x3, y3)");
            page.endText();

            page.beginText();
            page.moveTextPos(x + 5, y - 5);
            page.showText("Current point");
            page.moveTextPos(x1 - x, y1 - y);
            page.showText("(x1, y1)");
            page.moveTextPos(x2 - x1, y2 - y1);
            page.showText("(x2, y2)");
            page.moveTextPos(x3 - x2, y3 - y2);
            page.showText("(x3, y3)");
            page.endText();

            page.setDash(DASH_MODE1, 0);

            page.setLineWidth(0.5F);
            page.moveTo(x, y);
            page.lineTo(x1, y1);
            page.stroke();
            page.moveTo(x2, y2);
            page.lineTo(x3, y3);
            page.stroke();

            page.setDash(null, 0);

            page.setLineWidth(1.5F);
            page.moveTo(x, y);
            page.curveTo(x1, y1, x2, y2, x3, y3);
            page.stroke();
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    private void drawLine(HPdfPage page, float x, float y, String label) {
        page.beginText();
        page.moveTextPos(x, y - 10);
        page.showText(label);
        page.endText();
        
        page.moveTo(x, y - 15);
        page.lineTo(x + 220, y - 15);
        page.stroke();
    }
    
    private void drawLine2(HPdfPage page, float x, float y, String label) {
        page.beginText();
        page.moveTextPos(x, y);
        page.showText(label);
        page.endText();
        
        page.moveTo(x + 30, y - 25);
        page.lineTo(x + 160, y - 25);
        page.stroke();
    }
    
    private void drawRect(HPdfPage page, float x, float y, String label) {
        page.beginText();
        page.moveTextPos(x, y - 10);
        page.showText(label);
        page.endText();
        
        page.rectangle(x, y - 40, 220, 25);
    }
    
}
