/*
 * JHPdf Free PDF Library : GridSheet.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/grid_sheet.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;


public class GridSheet implements DemoEntry {
    public static void main(String[] args) {
        new GridSheet().demo(args);
    }
    
    private static final String F_NAME = "GridSheet.pdf";
    
    @Override
    public void demo(String[] args) {
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            
            page.setHeight(600);
            page.setWidth(400);
            printGrid(pdf, page);
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    public void printGrid(HPdfDocument pdf, HPdfPage page) throws HPdfException {
        float height = page.getHeight();
        float width = page.getWidth();
        HPdfFont font = pdf.getFont("Helvetica", null);
        
        page.setFontAndSize(font, 5);
        page.setGrayFill(0.5F);
        page.setGrayStroke(0.8F);
        
        /* Draw horizontal lines */
        int y = 0;
        while (y < height) {
            if (y % 10 == 0) {
                page.setLineWidth(0.5F);
            } else {
                if (page.getLineWidth() != 0.25F) {
                    page.setLineWidth(0.25F);
                }
            }
            page.moveTo(0, y);
            page.lineTo(width, y);
            page.stroke();
            
            if (y % 10 == 0 && y > 0) {
                page.setGrayStroke(0.5F);
                page.moveTo(0, y);
                page.lineTo(5, y);
                page.stroke();
                page.setGrayStroke(0.8F);
            }
            y += 5;
        }
        
        /* Draw virtical lines */
        int x = 0;
        while (x < width) {
            if (x % 10 == 0) {
                page.setLineWidth(0.5F);
            } else {
                if (page.getLineWidth() != 0.25F) {
                    page.setLineWidth(0.25F);
                }
            }
            page.moveTo(x, 0);
            page.lineTo(x, height);
            page.stroke();
            
            if (x % 50 == 0 && x > 0) {
                page.setGrayStroke(0.5F);
                
                page.moveTo(x, 0);
                page.lineTo(x, 5);
                page.stroke();
                
                page.moveTo(x, height);
                page.lineTo(x, height - 5);
                page.stroke();
                
                page.setGrayStroke(0.8F);
            }
            x += 5;
        }
        
        /* Draw horizontal text */
        y = 0;
        while (y < height) {
            if (y % 10 == 0 && y > 0) {
                page.beginText();
                page.moveTextPos(5, y - 2);
                page.showText(Integer.toString(y));
                page.endText();
            }
            y += 5;
        }
        
        /* Draw virtical text */
        x = 0;
        while (x < width) {
            if (x % 10 == 0 && x > 0) {
                page.beginText();
                page.moveTextPos(x, 5);
                page.showText(Integer.toString(y));
                page.endText();
                
                page.beginText();
                page.moveTextPos(x, height - 10);
                page.showText(Integer.toString(y));
                page.endText();
            }
            x += 5;
        }
        
        page.setGrayFill(0.5F);
        page.setGrayStroke(0.8F);
    }
}
