/*
 * JHPdf Free PDF Library : FontDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/character_map.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;


public class FontDemo implements DemoEntry {
    public static void main(String[] args) {
        new FontDemo().demo(args);
    }
    
    private static final String F_NAME = "FontDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        final String[] fontList = {
            "Courier",
            "Courier-Bold",
            "Courier-Oblique",
            "Courier-BoldOblique",
            "Helvetica",
            "Helvetica-Bold",
            "Helvetica-Oblique",
            "Helvetica-BoldOblique",
            "Times-Roman",
            "Times-Bold",
            "Times-Italic",
            "Times-BoldItalic",
            "Symbol",
            "ZapfDingbats"
        };
        
        final String pageTitle = "Font Demo";

        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* Add a new page object. */
            HPdfPage page = pdf.addPage();
            
            float height = page.getHeight();
            float width = page.getWidth();
            
            /* Print the lines of the page. */
            page.setLineWidth(1);
            page.rectangle(50, 50, width - 100, width - 110);
            page.stroke();
            
            /* Print the title of the page (with positioning center). */
            HPdfFont defFont = pdf.getFont("Helvetica", null);
            page.setFontAndSize(defFont, 24);
            
            float tw = page.textWidth(pageTitle);
            page.beginText();
            page.textOut((width - tw) / 2, height - 50, pageTitle);
            page.endText();
            
            /* output subtitle. */
            page.beginText();
            page.setFontAndSize(defFont, 16);
            page.textOut(60, height - 80, "<Standerd Type1 fonts samples>");
            page.endText();
            
            page.beginText();
            page.moveTextPos(60, height - 105);
            
            final String sampText = "abcdefgABCDEFG12345!#$%&+-@?";
            
            for (final String fontName : fontList) {
                HPdfFont font = pdf.getFont(fontName, null);
                
                /* print a label of text */
                page.setFontAndSize(defFont, 9);
                page.showText(fontName);
                page.moveTextPos(0, -18);
                
                /* print a sample text. */
                page.setFontAndSize(font, 20);
                page.showText(sampText);
                page.moveTextPos(0, -20);
            }
            
            page.endText();
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
}
