/*
 * JHPdf Free PDF Library : Encryption.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/arc_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfPageSizes;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfPageDirection;


public class Encryption implements DemoEntry {
    public static void main(String[] args) {
        new Encryption().demo(args);
    }
    
    private static final String text = "This is an encrypt document example.";
    private static final String ownerPasswd = "owner";
    private static final String userPasswd = "user";
    
    private static final String F_NAME = "Encryption.pdf";
    
    @Override
    public void demo(String[] args) {
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();

            page.setSize(HPdfPageSizes.B5, HPdfPageDirection.LANDSCAPE);
            
            page.beginText();
            page.setFontAndSize(font, 20);
            float tw = page.textWidth(text);
            page.moveTextPos((page.getWidth() - tw) / 2,
                (page.getHeight() - 20) / 2);
            page.showText(text);
            page.endText();
            
            pdf.setPassword(ownerPasswd, userPasswd);
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
}
