#ifndef _ECC2_H_
#define _ECC2_H_

#include <kernel.h>
#include <arch.h>

#define NUM_TASK		16
#define NUM_PRIORITY	16

extern TaskType runtask;
extern TaskStateType tstate[NUM_TASK];
extern TaskType tque[NUM_PRIORITY][NUM_TASK];
extern UB tque_num[NUM_PRIORITY];
extern UH tact[NUM_TASK];
extern CONTEXT tcontext[NUM_TASK];

extern void init(void);
extern BOOL activate(TaskType TaskID);
extern BOOL terminate(TaskType TaksID);
extern BOOL start(TaskType TaskID);
extern BOOL preempt(TaskType TaskID);
extern BOOL wait(TaskType TaskID);
extern void dispatch(void);

#endif /* _ECC2_H_ */

