﻿Public Class CtlImage

    Private _dispacher As FormDispacher = FormDispacher.GetInstance

    Public ReadOnly Property PictureBox As PictureBox
        Get
            Return _dispacher.GetPictureBox
        End Get
    End Property

    Private Sub btnRotate_Click(sender As Object, e As EventArgs) Handles btnRotate.Click
        Dim bmp As Bitmap = New Bitmap(_fileViewParam.FileName)
        '180度回転して、水平方向に反転
        '"Rotate180FlipX"の"Rotate180"は180度回転することを意味し、
        '"FlipX"は水平方向に反転することを意味する
        bmp.RotateFlip(RotateFlipType.Rotate180FlipX)
        '表示
        PictureBox.Image = bmp
    End Sub

    Private Sub CtlImage_Load(sender As Object, e As EventArgs) Handles MyBase.Load

    End Sub

    Private _fileViewParam As FileViewParam

    Public Sub SetFileInfo(f As FileViewParam)
        Me._fileViewParam = f
        If _fileViewParam Is Nothing Then
            _dispacher.HidePdfViewer()
        Else
            _dispacher.ShowPdfViewer()
        End If
        PictureBox.ImageLocation = _fileViewParam.FileName
        PictureBox.SizeMode = PictureBoxSizeMode.Zoom 'サイズ調整


    End Sub
End Class
