﻿Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports doubutu.UI.Form



'''<summary>
'''PositionTest のテスト クラスです。すべての
'''PositionTest 単体テストをここに含めます
'''</summary>
<TestClass()> _
Public Class PositionTest


    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    'テストを作成するときに、次の追加属性を使用することができます:
    '
    'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
    '<ClassInitialize()>  _
    'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    'End Sub
    '
    'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
    '<ClassCleanup()>  _
    'Public Shared Sub MyClassCleanup()
    'End Sub
    '
    '各テストを実行する前にコードを実行するには、TestInitialize を使用
    '<TestInitialize()>  _
    'Public Sub MyTestInitialize()
    'End Sub
    '
    '各テストを実行した後にコードを実行するには、TestCleanup を使用
    '<TestCleanup()>  _
    'Public Sub MyTestCleanup()
    'End Sub
    '
#End Region


    '''<summary>
    '''Position コンストラクター のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub PositionConstructorTest()
        Dim target As Position = New Position(1, 2)
        Assert.AreEqual(1, target.X)
        Assert.AreEqual(2, target.Y)
    End Sub

    '''<summary>
    '''Position コンストラクター のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub PositionConstructorTest1()

        Dim target1 As Position = New Position("00")
        Assert.AreEqual(0, target1.X)
        Assert.AreEqual(0, target1.Y)
        Dim target2 As Position = New Position("C2")
        Assert.AreEqual(3, target2.X)
        Assert.AreEqual(2, target2.Y)

    End Sub

    '''<summary>
    '''ToString のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub ToStringTest()
        Dim target1 As Position = New Position(1, 4)
        Assert.AreEqual("A4", target1.ToString)
        Dim target2 As Position = New Position(0, 0)
        Assert.AreEqual("00", target2.ToString)
    End Sub

    '''<summary>
    '''IsCaptured のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub IsCapturedTest()
        Dim target1 As Position = New Position("00")
        Assert.AreEqual(True, target1.IsCaptured)
        Dim target2 As Position = New Position("A1")
        Assert.AreEqual(False, target2.IsCaptured)

    End Sub

    '''<summary>
    '''op_Subtraction のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub op_SubtractionTest()
        Dim FromPos As New Position("B1")
        Dim ToPos As New Position("A1")
        Dim actual As Direction = ToPos - FromPos
        Dim expected As New Direction(-1, 0)
        Assert.AreEqual(True, expected = actual)
    End Sub
End Class
