﻿Imports System.Reflection

Public Class ImageLoader

    Public Shared _instance As New ImageLoader
    Public Shared Function GetInstance() As ImageLoader
        Return _instance
    End Function

    Private Sub New()
    End Sub

    Private _komaBitmap(10) As Bitmap

    Private _boardBitmap As Bitmap
    Public ReadOnly Property BoardBitmap() As Bitmap
        Get
            Return _boardBitmap
        End Get
    End Property

    Private _masuBitmap As Bitmap
    Public ReadOnly Property MasuBitmap() As Bitmap
        Get
            If _isBoardViewRotated Then
                Return _rotatedMasuBitmap
            End If
            Return _masuBitmap
        End Get
    End Property

    Private _rotatedMasuBitmap As Bitmap

    Private _isBoardViewRotated As Boolean


    Private _highLightBitmap As Bitmap
    Public ReadOnly Property HighLightBitmap As Bitmap
        Get
            Return _highLightBitmap
        End Get
    End Property

    Private executingAssembly As Assembly = Assembly.GetExecutingAssembly()

    Private Function GetBitmapFromResource(ByVal imageName As String) As Bitmap
        Dim resourceName As String = String.Format("doubutu.UI.Form.{0}", imageName)
        Dim resourceStream As System.IO.Stream = executingAssembly.GetManifestResourceStream(resourceName)
        Debug.Assert(resourceStream IsNot Nothing)
        Return New Bitmap(resourceStream)
    End Function


    Private Sub GetResourcesFromExecutingAssembly()
        Dim executingAssembly As Assembly = Assembly.GetExecutingAssembly()


        _boardBitmap = GetBitmapFromResource("ban.png")
        _masuBitmap = GetBitmapFromResource("masu.png")
        _rotatedMasuBitmap = GetBitmapFromResource("rotatedmasu.png")

        _highLightBitmap = GetBitmapFromResource("Highlight.bmp")

            _komaBitmap(Koma.SenteHI) = GetBitmapFromResource("senteHiyoko.bmp")
        _komaBitmap(Koma.SenteKI) = GetBitmapFromResource("senteKirin.bmp")
        _komaBitmap(Koma.SenteLI) = GetBitmapFromResource("senteLion.bmp")
        _komaBitmap(Koma.SenteNI) = GetBitmapFromResource("senteNiwatori.bmp")
        _komaBitmap(Koma.SenteZO) = GetBitmapFromResource("senteZou.bmp")
        _komaBitmap(Koma.GoteHI) = GetBitmapFromResource("goteHiyoko.bmp")
        _komaBitmap(Koma.GoteKI) = GetBitmapFromResource("goteKirin.bmp")
        _komaBitmap(Koma.GoteLI) = GetBitmapFromResource("goteLion.bmp")
        _komaBitmap(Koma.GoteNI) = GetBitmapFromResource("goteNiwatori.bmp")
        _komaBitmap(Koma.GoteZO) = GetBitmapFromResource("goteZou.bmp")



    End Sub

    Public Sub Load()
        GetResourcesFromExecutingAssembly()
    End Sub

    Public Sub SetBoardBiewRotated(ByVal isBoardViewRotated As Boolean)
        Me._isBoardViewRotated = isBoardViewRotated
    End Sub

    Public Function GetKomaImage(koma As Byte) As Bitmap
        Dim image As Bitmap = _komaBitmap(koma)
        If Me._isBoardViewRotated Then
            koma = KomaUtil.OppositeKoma(koma)
            image = _komaBitmap(koma)
        End If
        Return image
    End Function



End Class
