﻿Public Class Position

    ''' <summary>
    ''' 横位置
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property X As Integer

    ''' <summary>
    ''' 縦位置
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Y As Integer

    ''' <summary>
    ''' Positionを作成
    ''' </summary>
    ''' <param name="x"></param>
    ''' <param name="y"></param>
    ''' <remarks></remarks>
    Public Sub New(ByVal x As String, ByVal y As String)
        Debug.Assert((x = 0 AndAlso y = 0) OrElse (1 <= x AndAlso x <= 3 AndAlso 1 <= y AndAlso y <= 4))
        Me.X = x
        Me.Y = y
    End Sub

    ''' <summary>
    ''' 棋譜の位置文字列よりPositionを作成
    ''' </summary>
    ''' <param name="code"></param>
    ''' <remarks></remarks>
    Public Sub New(ByVal code As String)
        Debug.Assert(code.Length = 2)
        If code = "00" Then
            Me.X = 0
            Me.Y = 0
        Else
            Dim xcodeAsc As Integer = Asc(code(0))
            If Asc("A"c) <= xcodeAsc AndAlso xcodeAsc <= Asc("C"c) Then
                Me.X = xcodeAsc - Asc("A"c) + 1
            End If
            If Asc("a"c) <= xcodeAsc AndAlso xcodeAsc <= Asc("c"c) Then
                Me.X = xcodeAsc - Asc("a"c) + 1
            End If
            Dim ycodeAsc As Integer = Asc(code(1))
            Me.Y = ycodeAsc - Asc("0"c)
        End If
    End Sub

    ''' <summary>
    ''' 棋譜の文字列に変換
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function ToString() As String
        If 1 <= X AndAlso X <= 3 AndAlso
            1 <= Y AndAlso Y <= 4 Then
            Return Chr(Asc("A"c) + X - 1) & Y.ToString
        End If
        If X = 0 AndAlso Y = 0 Then
            Return "00" '持ち駒
        End If
        Return String.Empty
    End Function

    ''' <summary>
    ''' 持ち駒
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function IsCaptured() As Boolean
        Return X = 0 AndAlso Y = 0
    End Function

    ''' <summary>
    ''' 枠のなかに入っている。
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function IsInCell() As Boolean
        Return Not IsCaptured()
    End Function

    ''' <summary>
    ''' 持ち駒へ
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function Captured() As Position
        Return New Position(0, 0)
    End Function

    Shared Operator -(ByVal ToPos As Position, ByVal FromPos As Position) As Direction
        Dim x As Integer = ToPos.X - FromPos.X
        Dim y As Integer = ToPos.Y - FromPos.Y
        Return New Direction(x, y)
    End Operator

    Shared Operator =(ByVal op1 As Position, ByVal op2 As Position) As Boolean
        Return (op1.X = op2.X AndAlso op1.Y = op2.Y)
    End Operator

    Shared Operator <>(ByVal op1 As Position, ByVal op2 As Position) As Boolean
        Return Not op1 = op2
    End Operator
End Class
