﻿Public Class KansuuConverter



    Public Function GetKanji(ByVal number As Decimal) As String
        If 0 <= number AndAlso number <= 9 Then
            Return GetKanjiUnder9(number)
        End If
        If number <= 9999 Then
            Return GetKanjiUnder9999(number)
        End If
        Return GetKanjiUnderMuryouTaisu(number)
    End Function

    Public Function GetKanjiUnderMuryouTaisu(ByVal number As Decimal) As String
        Dim _rankOfMultipleOfFourKanji() As String = {
         "", "万", "億", "兆", "京", "垓",
         "予", "穣", "溝", "潤", "正", "載", "極",
            "恒河沙", "阿僧祇", "那由多", "不可思議", "無量大数"}
        Dim nums(_rankOfMultipleOfFourKanji.Length - 1)
        Dim n As Decimal = number
        For i As Integer = 0 To nums.Length - 1
            nums(i) = n Mod 10000
            n = n \ 10000
        Next
        Dim numstr As String = String.Empty
        For i As Integer = nums.Length - 1 To 0 Step -1
            If nums(i) = 0 Then
                Continue For
            End If
            numstr += GetKanjiUnder9999(nums(i))
            numstr += _rankOfMultipleOfFourKanji(i)
        Next
        Return numstr
    End Function

    Public Function GetKanjiUnder9999(ByVal number As Decimal) As String
        Dim _rankOfThreeKanji() As String = {"", "十", "百", "千"}
        Debug.Assert(0 <= number AndAlso number <= 9999)
        Dim nums(_rankOfThreeKanji.Length - 1) As Decimal
        Dim n As Decimal = number
        For i As Integer = 0 To nums.Length - 1
            nums(i) = n Mod 10
            n = n \ 10
        Next
        Dim numstr As String = String.Empty
        For i As Integer = nums.Length - 1 To 0 Step -1
            If nums(i) = 0 Then
                Continue For
            End If
            If i = 0 OrElse nums(i) <> 1 Then
                numstr += GetKanjiUnder9(nums(i))
            End If
            numstr += _rankOfThreeKanji(i)
        Next
        Return numstr
    End Function

    Public Function GetKanjiUnder9(ByVal number As Decimal) As String
        Dim _ZeroToTenKanji() As String = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"}
        Debug.Assert(0 <= number AndAlso number <= 9)
        Return _ZeroToTenKanji(number)
    End Function

    Private Sub New()
    End Sub
    Private Shared _instance As New KansuuConverter
    Public Shared Function GetInstance() As KansuuConverter
        Return _instance
    End Function

End Class
