﻿Imports System.Text
Imports Microsoft.VisualStudio.TestTools.UnitTesting

<TestClass()> Public Class KansuuConverterTest

    <TestMethod()> Public Sub TestMethod1()
        Dim kc As KansuuConverter = KansuuConverter.GetInstance()
        Assert.AreEqual("零", kc.GetKanji(0D))
        Assert.AreEqual("一", kc.GetKanji(1D))
        Assert.AreEqual("九", kc.GetKanji(9D))
        Assert.AreEqual("十", kc.GetKanji(10D))
        Assert.AreEqual("十一", kc.GetKanji(11D))
        Assert.AreEqual("二十", kc.GetKanji(20D))
        Assert.AreEqual("二十一", kc.GetKanji(21D))
        Assert.AreEqual("百", kc.GetKanji(100D))
        Assert.AreEqual("百一", kc.GetKanji(101D))
        Assert.AreEqual("千", kc.GetKanji(1000D))
        Assert.AreEqual("千二百三十八", kc.GetKanji(1238D))
        Assert.AreEqual("一万", kc.GetKanji(10000D))
        Assert.AreEqual("百億", kc.GetKanji(10000000000D))
        Assert.AreEqual("九千八百七十六兆五千四百三十二億千九百八十七万六千五百四十三", kc.GetKanji(9876543219876543D))
    End Sub

    <TestMethod()> Public Sub _0To9Test()
        Dim kc As KansuuConverter = KansuuConverter.GetInstance()
        Assert.AreEqual("零", kc.GetKanji(0D))
        Assert.AreEqual("一", kc.GetKanji(1D))
        Assert.AreEqual("二", kc.GetKanji(2D))
        Assert.AreEqual("三", kc.GetKanji(3D))
        Assert.AreEqual("四", kc.GetKanji(4D))
        Assert.AreEqual("五", kc.GetKanji(5D))
        Assert.AreEqual("六", kc.GetKanji(6D))
        Assert.AreEqual("七", kc.GetKanji(7D))
        Assert.AreEqual("八", kc.GetKanji(8D))
        Assert.AreEqual("九", kc.GetKanji(9D))
    End Sub

    <TestMethod()> Public Sub _10To9999Test()
        Dim kc As KansuuConverter = KansuuConverter.GetInstance()
        Assert.AreEqual("十", kc.GetKanji(10D))
        Assert.AreEqual("十一", kc.GetKanji(11D))
        Assert.AreEqual("百", kc.GetKanji(100D))
        Assert.AreEqual("千百十一", kc.GetKanji(1111D))
        Assert.AreEqual("八千八", kc.GetKanji(8008D))
        Assert.AreEqual("九千九百九十九", kc.GetKanji(9999))
    End Sub

End Class