﻿using System.IO;
using System.Windows;

namespace Azyobuzi.XamlIn.Installer.Models
{
    /// <summary>
    /// インストーラのリソースとして持つファイルソース
    /// </summary>
    public class File : DependencyObject
    {
        /// <summary>
        /// ソースファイル。絶対パスまたはXAMLからの相対パス。
        /// </summary>
        public string Source
        {
            get { return (string)GetValue(SourceProperty); }
            set { SetValue(SourceProperty, value); }
        }

        // Using a DependencyProperty as the backing store for Source.  This enables animation, styling, binding, etc...
        /// <summary>
        /// <see cref="Source"/>の依存プロパティの識別子
        /// </summary>
        public static readonly DependencyProperty SourceProperty =
            DependencyProperty.Register("Source", typeof(string), typeof(File));

        /// <summary>
        /// ファイルの識別子。被らなければなんでもOK
        /// </summary>
        public string Id { set; get; }
    }
}
