﻿using System.Windows;
using System.Windows.Controls;

namespace Azyobuzi.XamlIn.Installer.Models
{
    /// <summary>
    /// ダイアログのページとなる<see cref="Control"/>のコレクション
    /// </summary>
    public class DialogPageCollection : FreezableCollection<Control>
    {

        /// <summary>
        /// <see cref="IdProperty"/>の値を取得します。
        /// </summary>
        /// <param name="obj">読み取り元</param>
        /// <returns><see cref="IdProperty"/>の値</returns>
        public static string GetId(DependencyObject obj)
        {
            return (string)obj.GetValue(IdProperty);
        }

        /// <summary>
        /// <see cref="IdProperty"/>に値を設定します。
        /// </summary>
        /// <param name="obj">書き込み先</param>
        /// <param name="value">設定する値</param>
        public static void SetId(DependencyObject obj, string value)
        {
            obj.SetValue(IdProperty, value);
        }

        // Using a DependencyProperty as the backing store for Id.  This enables animation, styling, binding, etc...
        /// <summary>
        /// ダイアログページの識別子を格納する添付プロパティの識別子
        /// </summary>
        public static readonly DependencyProperty IdProperty =
            DependencyProperty.RegisterAttached("Id", typeof(string), typeof(DialogPageCollection), new UIPropertyMetadata(null));


        /// <summary>
        /// <see cref="IndexProperty"/>の値を取得します。
        /// </summary>
        /// <param name="obj">読み取り元</param>
        /// <returns><see cref="IdProperty"/>の値</returns>
        public static int? GetIndex(DependencyObject obj)
        {
            return (int?)obj.GetValue(IndexProperty);
        }

        /// <summary>
        /// <see cref="IndexProperty"/>に値を設定します。
        /// </summary>
        /// <param name="obj">書き込み先</param>
        /// <param name="value">設定する値</param>
        public static void SetIndex(DependencyObject obj, int? value)
        {
            obj.SetValue(IndexProperty, value);
        }

        // Using a DependencyProperty as the backing store for Index.  This enables animation, styling, binding, etc...
        /// <summary>
        /// ダイアログページの順番を格納する添付プロパティの識別子
        /// </summary>
        public static readonly DependencyProperty IndexProperty =
            DependencyProperty.RegisterAttached("Index", typeof(int?), typeof(DialogPageCollection), new UIPropertyMetadata(null));

        
    }
}
