﻿/*
win32_win.cpp
base class of screen driver

Made by Studio Breeze. 2002

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#include "stdafx.h"
#include "resource.h"
#include "sted_win32.h"
#include "sted_screen_win32.h"


#define MAX_LOADSTRING 100

#ifndef HINST_THISCOMPONENT
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#define HINST_THISCOMPONENT ((HINSTANCE)&__ImageBase)
#endif

 LRESULT CALLBACK
  Dlg_MidiDevices(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

CSTedScreenWin32::ptr_type CSTedScreenWin32::instance_;

/* accessor */

//CSTedScreenBase*
//CreateScreenDriver(int in_size)
//{
//  return (CSTedScreenBase *)CSTedScreenWin32::New(in_size);
//}

//void
//DestroyScreenDriver(CSTedScreenBase* in_driver)
//{
//  CSTedScreenWin32* self = (CSTedScreenWin32 *)in_driver;
//  self->Tidy();
//  delete self;
//}

inline CSTedScreenBase* GetDriver(void)
{
  return CSTedScreenWin32::instance().get();
}

void CSTedScreenWin32::init_instance()
{

  TCHAR title[MAX_LOADSTRING];					// タイトル バーのテキスト
  TCHAR window_class[MAX_LOADSTRING];			// メイン ウィンドウ クラス名
  TCHAR window_menu[MAX_LOADSTRING];

  LoadString(HINST_THISCOMPONENT, IDS_APP_TITLE, title, MAX_LOADSTRING);
  LoadString(HINST_THISCOMPONENT, IDC_STED2, window_class, MAX_LOADSTRING);
  LoadString(HINST_THISCOMPONENT, IDC_STED2, window_menu, MAX_LOADSTRING);

  //(LPCTSTR)IDC_STED2

  timeBeginPeriod(1);

  instance_.reset(new CSTedScreenWin32(std::wstring(window_menu),std::wstring(window_class),false,0.0f,0.0f));
  instance_->create();
  instance_->show();
  instance_->update();
  instance_->Construct(16);

  //TODO ご飯をたべる。
  // UNDONE これは

  //MyRegisterClass(hInstance);
  //
  //if (!InitInstance (hInstance, nCmdShow)) 
  //{
  //	return FALSE;
  //}


}

  void CSTedScreenWin32::create()
  {
      create_device_independent_resources();
      //    icon_ = ::LoadIconW(HINST_THISCOMPONENT,MAKEINTRESOURCE(IDI_ICON1));
      register_class(
      (wchar_t*)IDC_STED2,
      CS_HREDRAW | CS_VREDRAW,
      0,
      0,
      LoadIcon(HINST_THISCOMPONENT, (LPCTSTR)IDI_STED2),
      LoadCursor(NULL, IDC_ARROW),
      CreateSolidBrush(0x00000000),
      LoadIcon(HINST_THISCOMPONENT, (LPCTSTR)IDI_SMALL)
      );

//      register_class(this->name_.c_str(),CS_HREDRAW | CS_VREDRAW ,0,DLGWINDOWEXTRA,icon_.get());
    create_window();
  };

/* class */

CSTedScreenWin32::CSTedScreenWin32(const std::wstring& menu_name,const std::wstring& name,bool fit_to_display,float width,float height) :
sf::base_win32_window<>(menu_name,name,fit_to_display,width,height)
{

  // fWindow = NULL;
  fMenu = NULL;
  //fWindowDC = NULL;

  //fText = NULL;
  //fTextMask = NULL;
  //fGraphicsWindow[0] = NULL;
  //fGraphicsWindow[1] = NULL;
  //fOffScreen = NULL;
  fOffScreenIsDirty = FALSE;
  fCanUpdateWindow = TRUE;

  //fTextDC = NULL;
  //fTextMaskDC = NULL;
  //fGraphicsWindowDC[0] = NULL;
  //fGraphicsWindowDC[1] = NULL;
  //fOffScreenDC = NULL;

  fCurrentTextX = 0;
  fCurrentTextY = 0;
  fTextOriginY = 0;
  fTextHeight = fX68TextHeight;
  fIsCursorOn = FALSE;
  fCurrentGraphics = 0;

  fWindowWidth = 768;
  fWindowHeight = 512;
  fTextLineHeight = 12;

  fUCS2Buf = NULL;
  fSJISBuf = NULL;
  const int fUCS2BufLen = 1024;
  const int fSJISBufLen = 1024;

  fCurrentTextColor = 0;
  fCurrentTextBackColor = 0;
  fCurrentGraphicsColor = 0;

  //fBrushMaskOff = NULL;
  //fBrushMaskOn = NULL;

  fFileDirHandle = NULL;

  fMidiInDevice = NULL;
  fMidiInPort = 0;

  for (int i = 0; i < fMidiOutPorts; i++) 
  {
    fMidiOutDevice[i] = NULL;
    fMidiOutPort[i] = 0; // default device
  }
  fMidiOutPacket[0] = -1;
  fMidiOutPacket[1] = -1;
  fMidiOutPacket[2] = -1;
  fMidiOutPacket[3] = -1;
  accel_ = LoadAccelerators(HINST_THISCOMPONENT, (LPCTSTR)IDC_STED2);

  fTimerEventNotified = FALSE;

  fConstructed = FALSE;

}

void CSTedScreenWin32::Construct(int in_size)
{
  int fw, fh;
  int w,h;
  int i;
//  HFONT font;


  try {

 /*   ::ZeroMemory((void *)&lf, sizeof(LOGFONT));
    std::wstring font_face(L"みかちゃん");
    lf.lfHeight = in_size;
    lf.lfWidth = 0;
    lf.lfWeight = 0;
    lf.lfItalic = 0;
    lf.lfUnderline = 0;
    lf.lfCharSet = SHIFTJIS_CHARSET;
    lf.lfPitchAndFamily = FIXED_PITCH | FF_DONTCARE;
    font = ::CreateFontIndirect(&lf);*/



    if (in_size < 0) return;
    fh = in_size;
    fw = in_size/2;
    w = fw * fX68TextWidth;
    h = fh * fX68TextHeight;

    fMenu = ::GetMenu(hwnd_);

    if (!hwnd_ || !fMenu) return;

    // off-screen bitmaps

    // fText = ::CreateCompatibleBitmap(fWindowDC, w, h);

 
    //	hr = render_target_->CreateCompatibleRenderTarget(s,&graphics_bitmap_target_[1]);
    //	if(FAILED(hr)) return;

    //fTextMask = ::CreateBitmap(w, h, 1, 1, NULL);
    //if (!fTextMask) return;
    // fGraphicsWindow[0] = ::CreateCompatibleBitmap(fWindowDC, w, h);
    // if (!fGraphicsWindow[0]) return;
    // fGraphicsWindow[1] = ::CreateCompatibleBitmap(fWindowDC, w, h);
    // if (!fGraphicsWindow[1]) return;
    // fOffScreen = ::CreateCompatibleBitmap(fWindowDC, w, h);
    // if (!fOffScreen) return;

    // device contexts
    //fTextDC = ::CreateCompatibleDC(fWindowDC);
    //if (!fTextDC) return;
    //::SelectObject(fTextDC, fText);
    //fTextMaskDC = ::CreateCompatibleDC(fWindowDC);
    //if (!fTextMaskDC) return;
    //::SelectObject(fTextMaskDC, fTextMask);
    //fGraphicsWindowDC[0] = ::CreateCompatibleDC(fWindowDC);
    //if (!fGraphicsWindowDC[0]) return;
    //::SelectObject(fGraphicsWindowDC[0], fGraphicsWindow[0]);
    //fGraphicsWindowDC[1] = ::CreateCompatibleDC(fWindowDC);
    //if (!fGraphicsWindowDC[1]) return;
    //::SelectObject(fGraphicsWindowDC[1], fGraphicsWindow[1]);
    //fOffScreenDC = ::CreateCompatibleDC(fWindowDC);
    //if (!fOffScreenDC) return;
    //::SelectObject(fOffScreenDC, fOffScreen);

    //::SelectObject(fTextDC, font);
    //::SelectObject(fTextMaskDC, font);
    //::SelectObject(fGraphicsWindowDC[0], font);
    //::SelectObject(fGraphicsWindowDC[1], font);
    //::SelectObject(fOffScreenDC, font);
    //::SetBkMode(fTextDC, TRANSPARENT);
    //::SetBkMode(fTextMaskDC, TRANSPARENT);
    //::SetBkMode(fGraphicsWindowDC[0], TRANSPARENT);
    //::SetBkMode(fGraphicsWindowDC[1], TRANSPARENT);
    //::SetBkMode(fOffScreenDC, TRANSPARENT);
    //::SetTextColor(fTextDC, RGB(0xff, 0xff, 0xff));
    //::SetTextColor(fTextMaskDC, RGB(0x00, 0x00, 0x00));

    fWindowWidth = w;
    fWindowHeight = h;
    fTextLineHeight = fh;


    // TODO UCSバッファ必要か？後ほど確認
    fUCS2Buf = (LPTSTR)malloc(sizeof(WCHAR) * fUCS2BufLen);
    if (!fUCS2Buf) return;

    // TODO UCSバッファ必要か？後ほど確認
    fSJISBuf = (char *)malloc(sizeof(char) * fSJISBufLen);
    if (!fSJISBuf) return;



    //fBrushMaskOn = ::CreateSolidBrush(RGB(0xff,0xff,0xff));
    //if (!fBrushMaskOn) return;
    //fBrushMaskOff = ::CreateSolidBrush(RGB(0x00,0x00,0x00));
    //if (!fBrushMaskOff) return;
    //fBrushClear = ::CreateSolidBrush(RGB(0x00,0x00,0x00));
    //if (!fBrushClear) return;
    //fBrushTextClear = ::CreateSolidBrush(RGB(0xff,0xff,0xff));
    //if (!fBrushTextClear) return;

    for (i = 0; i < 3; i++) 
    {
      SetTextPalette(i, 0);
    }

    h += ::GetSystemMetrics(SM_CYCAPTION);
    h += ::GetSystemMetrics(SM_CYMENU);
    h += (::GetSystemMetrics(SM_CYSIZEFRAME) * 2);
    w += ::GetSystemMetrics(SM_CXSIZEFRAME) * 2;

    ::SetWindowPos(
      hwnd_, HWND_TOP, 150, 150, w, h,
      SWP_DRAWFRAME | SWP_NOMOVE | SWP_NOZORDER);

    // デバイス非依存リソースの作成
    create_device_independent_resources();

    // デバイス依存リソースの作成
    create_device();

    fConstructed = TRUE;
  } catch (...){
    fConstructed = FALSE;
  }
}

//CSTedScreenWin32*
//CSTedScreenWin32::New(int in_screensize)
//{
//  CSTedScreenWin32* self;
//  self = new CSTedScreenWin32;
//  if (!self) return NULL;
//
//  self->Construct(in_screensize);
//  if (!self->fConstructed) {
//    self->Tidy();
//    delete self;
//    return NULL;
//  }
//  return self;
//}

CSTedScreenWin32::~CSTedScreenWin32()
{
}

void
  CSTedScreenWin32::Tidy(void)
{
  //if (fTextDC) ::DeleteDC(fTextDC);
  //fTextDC = NULL;
  //if (fTextMaskDC) ::DeleteDC(fTextMaskDC);
  //fTextMaskDC = NULL;
  //if (fGraphicsWindowDC[0]) ::DeleteDC(fGraphicsWindowDC[0]);
  //fGraphicsWindowDC[0] = NULL;
  //if (fGraphicsWindowDC[1]) ::DeleteDC(fGraphicsWindowDC[1]);
  //fGraphicsWindowDC[2] = NULL;
  //if (fOffScreenDC) ::DeleteDC(fOffScreenDC);
  //fOffScreenDC = NULL;

 /* if (fText) ::DeleteObject(fText);
  fText = NULL;
  if (fTextMask) ::DeleteObject(fTextMask);
  fTextMask = NULL;
  if (fGraphicsWindow[0]) ::DeleteObject(fGraphicsWindow[0]);
  fGraphicsWindow[0] = NULL;
  if (fGraphicsWindow[1]) ::DeleteObject(fGraphicsWindow[1]);
  fGraphicsWindow[1] = NULL;
  if (fOffScreen) ::DeleteObject(fOffScreen);
  fOffScreen = NULL;*/

  //if (fUCS2Buf) free((void *)fUCS2Buf);
  //fUCS2Buf = NULL;
  //if (fSJISBuf) free((void *)fSJISBuf);
  //fSJISBuf = NULL;

  //if (fBrushMaskOn) ::DeleteObject(fBrushMaskOn);
  //fBrushMaskOn = NULL;
  //if (fBrushMaskOff) ::DeleteObject(fBrushMaskOff);
  //fBrushMaskOff = NULL;
  //if (fBrushClear) ::DeleteObject(fBrushClear);
  //fBrushClear = NULL;
  //if (fBrushTextClear) ::DeleteObject(fBrushTextClear);
  //fBrushTextClear = NULL;

  discard_device();
  render_target_.Reset();

  if (fFileDirHandle) {
    ::FindClose(fFileDirHandle);
    fFileDirHandle = NULL;
  }

  ::SetRectEmpty(&fInvalidRect);

  fCanUpdateWindow = TRUE;

  fTimerEventNotified = FALSE;

  fConstructed = FALSE;
}

// window
void
  CSTedScreenWin32::InitWindow(void)
{
  RECT r1;

  ::SetRect(&r1, 0, 0, fWindowWidth, fWindowHeight);
  D2D1_RECT_F r(D2D1::RectF(0.0f,0.0f,(float)fWindowWidth,(float)fWindowHeight));

  sf::begin_draw<ID2D1BitmapRenderTargetPtr> draw_text(text_bitmap_target_);
  sf::begin_draw<ID2D1BitmapRenderTargetPtr> draw_g_bitmap1(graphics_bitmap_target_[0]);
  sf::begin_draw<ID2D1BitmapRenderTargetPtr> draw_g_bitmap2(graphics_bitmap_target_[1]);

  text_bitmap_target_->FillRectangle(r,brush_text_clear_.Get());
  graphics_bitmap_target_[0]->FillRectangle(r,brush_clear_.Get());
  graphics_bitmap_target_[1]->FillRectangle(r,brush_clear_.Get());

  //::FillRect(fTextDC, &r, fBrushTextClear);
  //::FillRect(fTextMaskDC, &r, MASK_OFF);
  //::FillRect(fGraphicsWindowDC[0], &r, fBrushClear);
  //::FillRect(fGraphicsWindowDC[1], &r, fBrushClear);
  //::FillRect(fOffScreenDC, &r, fBrushClear);

  //::SetTextColor(fTextDC, RGB(0xff, 0xff, 0xff));
  ////::SetTextColor(fTextMaskDC, RGB(0xff, 0xff, 0xff));
  //::SetBkColor(fTextDC, RGB(0x00, 0x00, 0x00));
  //::SetBkColor(fTextMaskDC, RGB(0xff, 0xff, 0xff));
  //::SetBkMode(fTextDC, OPAQUE);
  //::SetBkMode(fTextMaskDC, OPAQUE);

  //::SetTextColor(fGraphicsWindowDC[0], RGB(0xff, 0xff, 0xff));
  //::SetTextColor(fGraphicsWindowDC[1], RGB(0xff, 0xff, 0xff));
  //::SetBkColor(fGraphicsWindowDC[0], RGB(0x00, 0x00, 0x00));
  //::SetBkColor(fGraphicsWindowDC[1], RGB(0x00, 0x00, 0x00));
  //::SetBkMode(fGraphicsWindowDC[0], OPAQUE);
  //::SetBkMode(fGraphicsWindowDC[1], OPAQUE);

  //::SetTextColor(fOffScreenDC, RGB(0x00, 0x00, 0x00));
  //::SetBkColor(fOffScreenDC, RGB(0xff, 0xff, 0xff));
  //::SetBkMode(fOffScreenDC, OPAQUE);

  ::SetRectEmpty(&fInvalidRect);

  ::memset((void *)fUCS2Buf, 0, sizeof(WCHAR)*fUCS2BufLen);
  ::memset((void *)fSJISBuf, 0, sizeof(char)*fSJISBufLen);

  fCurrentTextX = 0;
  fCurrentTextY = 0;
  fIsCursorOn = FALSE;
  fCurrentGraphics = 0;
  fCurrentTextColor = 3;
  fCurrentTextBackColor = 0;
  fCurrentGraphicsColor = 0;

  InvalidateRect(&r1);
}

void
  CSTedScreenWin32::CloseWindow(void)
{
}

void
  CSTedScreenWin32::RepaintWindow(void)
{
  InvalidateRect(NULL);
}

void
  CSTedScreenWin32::UpdateWindow(void)
{
  fCanUpdateWindow = TRUE;
  ::UpdateWindow(hwnd_);
}

void
  CSTedScreenWin32::DisableUpdateWindow(void)
{
  fCanUpdateWindow = FALSE;
}


// private
void
  CSTedScreenWin32::InvalidateRect(const RECT *in_rect)
{
  RECT r;
  int w,h;

  if (::IsRectEmpty(&fInvalidRect)) {
    ::CopyRect(&r, in_rect);
  } else {
    ::UnionRect(&r, &fInvalidRect, in_rect);
  }
  w = r.right - r.left;
  h = r.bottom - r.top;
  if (fCanUpdateWindow && (w*h > fWindowHeight * fWindowWidth / 8)) 
  {
    update();
  } else {
    ::CopyRect(&fInvalidRect, &r);
  }

  ::InvalidateRect(hwnd_, in_rect, FALSE);
  fOffScreenIsDirty = TRUE;
}

void
  CSTedScreenWin32::InvalidateRect(const int in_x, const int in_y, const int in_w, const int in_h)
{
  RECT r;
  ::SetRect(&r, in_x, in_y, in_x+in_w, in_y+in_h);
  InvalidateRect(&r);
}

// public
void
  CSTedScreenWin32::Paint(RECT *in_rect,HDC dc)
{
  int x,y;
  int w,h;

  x = in_rect->left;
  y = in_rect->top;
  w = in_rect->right-x;
  h = in_rect->bottom-y;
  D2D1_RECT_F r= {in_rect->left,in_rect->top,in_rect->right,in_rect->bottom}; 

  if (fOffScreenIsDirty) {

    ID2D1BitmapPtr bitmap_text;
    ID2D1BitmapPtr bitmap_graphics;

    graphics_bitmap_target_[fCurrentGraphics]->GetBitmap(&bitmap_graphics);
    text_bitmap_target_->GetBitmap(&bitmap_text);

    //ID2D1SolidColorBrushPtr brushr;
    //text_bitmap_target_->CreateSolidColorBrush(D2D1::ColorF(1.0f,0.0f,0.0f), &brushr);

    //text_bitmap_target_->BeginDraw();
    //text_bitmap_target_->Clear(D2D1::ColorF(0.0f,0.0f,0.0f,0.0f));
    //std::wstring a(L"test test test");
    //  text_bitmap_target_->DrawTextW(
    //a.c_str(),a.size(),text_fmt_,D2D1::RectF(0,0,300,300),brushr);

    //text_bitmap_target_->EndDraw();



    
    {
      sf::begin_draw<ID2D1HwndRenderTargetPtr> begin(render_target_);
      render_target_->PushAxisAlignedClip(r,render_target_->GetAntialiasMode());
      render_target_->Clear(D2D1::ColorF(0.0f,0.0f,0.0f,1.0f));
      render_target_->PopAxisAlignedClip();
      render_target_->DrawBitmap(bitmap_graphics.Get(),r,1.0f,D2D1_BITMAP_INTERPOLATION_MODE_LINEAR,r);
      render_target_->DrawBitmap(bitmap_text.Get(),r,1.0f,D2D1_BITMAP_INTERPOLATION_MODE_LINEAR,r);

      //ID2D1SolidColorBrushPtr brushr;
      //render_target_->CreateSolidColorBrush(D2D1::ColorF(1.0f,0.0f,0.0f), &brushr);
      //render_target_->FillRectangle(D2D1::RectF(0.0f,0.0f,200.0f,200.0f),brushr);
      //::BitBlt(fOffScreenDC, x,y,w,h, fGraphicsWindowDC[fCurrentGraphics], x,y, SRCCOPY);
      //::BitBlt(fOffScreenDC, x,y,w,h, fTextMaskDC, x,y, SRCPAINT);
      //::BitBlt(fOffScreenDC, x,y,w,h, fTextDC, x,y, SRCAND);
      //::BitBlt(dc, x,y,w,h, fGraphicsWindowDC[fCurrentGraphics], x,y, SRCCOPY);
      //::BitBlt(dc, x,y,w,h, fTextMaskDC, x,y, SRCPAINT);
      //::BitBlt(dc, x,y,w,h, fTextDC, x,y, SRCAND);
      // THROW_IF_ERR(begin.end_draw());
    }

    fOffScreenIsDirty = FALSE;
    ::SetRectEmpty(&fInvalidRect);
  }

  //::BitBlt(dc, x,y,w,h, fOffScreenDC, x,y, SRCCOPY);

  fCanUpdateWindow = TRUE;
}

LPCTSTR
  CSTedScreenWin32::toUCS2(const char* in_str, int *out_len)
{
  return toUCS2(in_str, (int)::strlen(in_str), out_len);
}

LPCTSTR 
  CSTedScreenWin32::toUCS2(const char* in_str, int in_len, int *out_len)
{
#ifdef _UNICODE
  int bytes;
  bytes = ::MultiByteToWideChar(CP_ACP, 0, in_str, in_len, fUCS2Buf, fUCS2BufLen);
  if (out_len) *out_len = bytes;
  return fUCS2Buf;
#else
  int bytes = in_len;
  if (fUCS2BufLen<=in_len) bytes = fUCS2BufLen-1;
  ::memcpy((void *)fUCS2Buf, in_str, bytes);
  ((char *)fUCS2Buf)[bytes] = '\0';
  if (out_len) *out_len = bytes;
  return fUCS2Buf;
#endif
}

const char*
  CSTedScreenWin32::toSJIS(LPCTSTR in_str, int *out_len)
{
#ifdef _UNICODE
  int bytes;
  bytes = ::WideCharToMultiByte(CP_ACP, 0, in_str, -1, fSJISBuf, fSJISBufLen, NULL, NULL);
  if (out_len) *out_len = bytes;
  return fSJISBuf;
#else
  int bytes;
  bytes = (int)::strlen(in_str);
  if (bytes>=fSJISBufLen) bytes = fSJISBufLen-1;
  ::memcpy((void *)fSJISBuf, in_str, bytes);
  fSJISBuf[bytes] = '\0';
  if (out_len) *out_len = bytes;
  return fSJISBuf;
#endif
}

void
  Exit(int in_result)
{
  ::PostQuitMessage(in_result);
  ::exit(in_result);
}

// player control
//static LRESULT
//Player_PlayAll(CSTedScreenWin32* in_drv)
//{
//	if (in_drv) {
//		in_drv->NotifyKeyPressed(VK_NONCONVERT);
//	}
//	return 0;
//}

//static LRESULT
//Player_PlayTrack(CSTedScreenWin32* in_drv)
//{
//	if (in_drv) {
//		in_drv->NotifyKeyPressed(VK_SHIFT);
//		in_drv->NotifyKeyPressed(VK_LMENU);
//	}
//	return 0;
//}

//static LRESULT
//Player_PlayMeas(CSTedScreenWin32* in_drv)
//{
//	if (in_drv) {
//		in_drv->NotifyKeyPressed(VK_LMENU);
//	}
//	return 0;
//}

//static LRESULT
//Player_PlayStop(CSTedScreenWin32* in_drv)
//{
//	if (in_drv) {
//		in_drv->NotifyKeyPressed(VK_RMENU);
//	}
//	return 0;
//}

//static LRESULT
//Player_ToggleTrace(CSTedScreenWin32* in_drv)
//{
//	HMENU menu;
//	MENUITEMINFO info;
//
//	::ZeroMemory((void *)&info, sizeof(MENUITEMINFO));
//	info.cbSize = sizeof(MENUITEMINFO);
//	info.fMask = MIIM_STATE;
//
//	menu = STedGetMenu();
//	if (in_drv && menu) {
//		if (::GetMenuItemInfo(menu, IDM_PLAY_TRACE, FALSE, &info)) {
//			info.fState = (info.fState&MFS_CHECKED) ? MFS_UNCHECKED : MFS_CHECKED;
//			::SetMenuItemInfo(menu, IDM_PLAY_TRACE, FALSE, &info);
//			if (info.fState&MFS_CHECKED) {
//				in_drv->NotifyKeyPressed(VK_LCONTROL);
//			} else {
//				in_drv->NotifyKeyReleased(VK_LCONTROL);
//			}
//		}
//	}
//	return 0;
//}

//static LRESULT
//RhythmEdit_CurrentMeas(CSTedScreenWin32* in_drv)
//{
//	if (in_drv) {
//		in_drv->NotifyKeyPressed(0xd8);
//	}
//	return 0;
//}

//static LRESULT
//RhythmEdit_NewMeas(CSTedScreenWin32* in_drv)
//{
//	if (in_drv) {
//		in_drv->NotifyKeyPressed(0xd9);
//	}
//	return 0;
//}

LRESULT CSTedScreenWin32::window_proc(HWND hwnd,boost::uint32_t message, WPARAM wParam, LPARAM lParam)
{
  int wmId, wmEvent;
  //PAINTSTRUCT ps;
//  HDC hdc;
//  RECT r;

  switch (message) 
  {
  case WM_CREATE:
    //create_device();
    return ::DefWindowProcW(hwnd,message,wParam,lParam);
    break;
  case WM_DWMWINDOWMAXIMIZEDCHANGE:
    ::OutputDebugStringW(L"WM_DWMWINDOWMAXIMIZEDCHANGE\n");
    break;
  case WM_ACTIVATE:
    ::OutputDebugStringW(L"WM_ACTIVATE\n");
    break;
  case WM_ACTIVATEAPP:
    ::OutputDebugStringW(L"WM_ACTIVATEAPP\n");
    break;
  case WM_SIZING:
    ::OutputDebugStringW(L"WM_SIZING\n");
    break;
  case WM_SIZE:
    {
      ::OutputDebugStringW(L"WM_SIZE\n");


      if (wParam == SIZE_RESTORED  )
      {
        if (render_target_)
        {
          InvalidateRect(0,0,fWindowWidth,fWindowHeight);
          //D2D1_SIZE_U size;
          //size.width = lParam & 0xFFFF;
          //size.height = (lParam >> 16) & 0xFFFF; ;
          //if(size.width != fWindowWidth || size.height != fWindowHeight){
          //  render_target_->Resize(size);
          //  discard_device();
          //  create_device();

          //  sf::begin_draw<ID2D1BitmapRenderTargetPtr> draw_text(text_bitmap_target_);
          //  sf::begin_draw<ID2D1BitmapRenderTargetPtr> draw_g_bitmap1(graphics_bitmap_target_[0]);
          //  sf::begin_draw<ID2D1BitmapRenderTargetPtr> draw_g_bitmap2(graphics_bitmap_target_[1]);

          //  D2D1_COLOR_F clear_color = D2D1::ColorF(0.0f,0.0f,0.0f,0.0f);
          //  text_bitmap_target_->Clear(clear_color);
          //  graphics_bitmap_target_[0]->Clear(clear_color);
          //  graphics_bitmap_target_[1]->Clear(clear_color);
          //  draw_text.end_draw();
          //  draw_g_bitmap1.end_draw();
          //  draw_g_bitmap2.end_draw();
          //}
        }
      }

    }
    break;
  case WM_ERASEBKGND:
    {
      return FALSE;
    }
    break;
  case WM_DISPLAYCHANGE:
    {
      ::InvalidateRect(hwnd, NULL, FALSE);
      return ::DefWindowProcW(hwnd,message,wParam,lParam);

    }
    break;
  case WM_COMMAND:
    wmId    = LOWORD(wParam); 
    wmEvent = HIWORD(wParam); 
    // 選択されたメニューの解析 :
    switch (wmId)
    {
    case IDM_ABOUT:
      DialogBox(HINST_THISCOMPONENT, (LPCTSTR)IDD_ABOUTBOX, hwnd_, (DLGPROC)About);
      break;
    case IDM_EXIT:
      DestroyWindow(hwnd_);
      break;
    case IDM_PREFS_MIDIPORTS:
      DialogBox(HINST_THISCOMPONENT, (LPCTSTR)IDD_PREF_MIDIDEVICE, hwnd_, (DLGPROC)Dlg_MidiDevices);
      break;
    case IDM_PLAY_PLAYALL:
      NotifyKeyPressed(VK_NONCONVERT);
      return 0;
      break;
    case IDM_PLAY_PLAYTRACK:
      NotifyKeyPressed(VK_SHIFT);
      NotifyKeyPressed(VK_LMENU);
      return 0;
      break;
    case IDM_PLAY_PLAYMEASURE:
      NotifyKeyPressed(VK_LMENU);
      return 0;
      break;
    case IDM_PLAY_STOP:
      NotifyKeyPressed(VK_RMENU);
      return 0;
      break;
    case IDM_PLAY_TRACE:
      {
        HMENU menu;
        MENUITEMINFO info;

        ::ZeroMemory((void *)&info, sizeof(MENUITEMINFO));
        info.cbSize = sizeof(MENUITEMINFO);
        info.fMask = MIIM_STATE;

        menu = ::GetMenu(hwnd_);
        if (menu) {
          if (::GetMenuItemInfo(menu, IDM_PLAY_TRACE, FALSE, &info)) {
            info.fState = (info.fState&MFS_CHECKED) ? MFS_UNCHECKED : MFS_CHECKED;
            ::SetMenuItemInfo(menu, IDM_PLAY_TRACE, FALSE, &info);
            if (info.fState&MFS_CHECKED) {
              NotifyKeyPressed(VK_LCONTROL);
            } else {
              NotifyKeyReleased(VK_LCONTROL);
            }
          }
        }
        return 0;
      }
      break;
    case IDM_EDIT_RHYTHMTRACK_CURRENTMEAS:
      NotifyKeyPressed(0xd8);
      return 0;
      break;
    case IDM_EDIT_RHYTHMTRACK_NEWMEAS:
      NotifyKeyPressed(0xd9);
      return 0;
      break;
    }
    break;

  case WM_KEYDOWN:
    NotifyKeyPressed((int)wParam);
    return 0;
    break;
  case WM_KEYUP:
    NotifyKeyReleased((int)wParam);
    break;
  case WM_SYSKEYDOWN:

    if (wParam==VK_F10) {
      NotifyKeyPressed((int)wParam);
      return 0;
    }
    break;
  case WM_SYSKEYUP:
    if (wParam==VK_F10) {
      NotifyKeyReleased((int)wParam);
      return 0;
    } 
    break;
  case WM_CHAR:
    NotifyChar((int)wParam);
    return 0;
    break;

  case WM_PAINT:
    {
      RECT rc;
      if (::GetUpdateRect(hwnd_, &rc, FALSE))
      { 
        // 描画開始
        sf::paint_struct ps(hwnd_);
        //RECT rc;

        // クライアント領域を求める
        GetClientRect(
          hwnd_,
          &rc
          );

        // DC描画
        Paint(&rc,ps->hdc);

        // Direct2DレンダーターゲットにHDCをバインド
        //THROW_IF_ERR(render_target_->BindDC(
        //						ps->hdc
        //	,
        //	&rc
        //	));

        //					render_target_->BeginDraw();

        // Direct2D描画開始。オブジェクトの破棄と同時に描画終了
        //sf::begin_draw<ID2D1DCRenderTargetPtr> d(render_target_);
        //{sf::begin_draw<ID2D1HwndRenderTargetPtr> d(render_target_);

        //ID2D1SolidColorBrushPtr brushr;
        //render_target_->CreateSolidColorBrush(D2D1::ColorF(D2D1::ColorF::Aqua), &brushr);

        //D2D1_RECT_F layoutRect = D2D1::RectF(rc.left, rc.top, rc.right,rc.bottom);
        //IDWriteTextFormatPtr write_text_format;

        //// Text Formatの作成
        //THROW_IF_ERR(write_factory_->CreateTextFormat(
        //  L"メイリオ",                // Font family name.
        //  NULL,                       // Font collection (NULL sets it to use the system font collection).
        //  DWRITE_FONT_WEIGHT_BOLD,
        //  DWRITE_FONT_STYLE_NORMAL,
        //  DWRITE_FONT_STRETCH_NORMAL,
        //  48.0f,
        //  L"ja-jp",
        //  &write_text_format
        //  ));

        //// テキストの描画
        //std::wstring t = L"とりあえずDirect2DとDC描画を混在させてみました。";

        //render_target_->DrawTextW(
        //  t.c_str(),
        //  t.size(),
        //  write_text_format,
        //  layoutRect, 
        //  brushr);
        //}

      } // スコープが外れるとともに描画終了。
      //}
    }
    return 0L;
    break;
  case WM_MOUSEMOVE:
    NotifyPointerPosition(LOWORD(lParam), HIWORD(lParam), (int)wParam);
    return 0;
    break;
  case WM_LBUTTONDOWN:
    NotifyPointerButtonState(EButtonLeft, EButtonOn);
    return 0;
    break;
  case WM_RBUTTONDOWN:
    NotifyPointerButtonState(EButtonRight, EButtonOn);
    return 0;
    break;
  case WM_LBUTTONUP:
    NotifyPointerButtonState(EButtonLeft, EButtonOff);
    return 0;
    break;
  case WM_RBUTTONUP:
    NotifyPointerButtonState(EButtonRight, EButtonOff);
    return 0;
    break;
  case MM_MIM_DATA:
    NotifyMidiIn((unsigned long)lParam);
    break;
  case WM_TIMER:
    NotifyTimer((UINT)wParam);
    break;
  case WM_CLOSE:
    Tidy();
    break;
  case WM_DESTROY:
    PostQuitMessage(0);
    break;
  case WM_QUIT:
    ::exit(0);
    break;
  }
  return DefWindowProc(hwnd_, message, wParam, lParam);
  ;
}

 const char* get_version_id(void);

LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
  case WM_INITDIALOG:
    {
      CSTedScreenWin32* drv;
      LPCTSTR u;
      char buf[1024];

      drv = (CSTedScreenWin32 *)GetDriver();
      if (drv) {
        ::strcpy(buf, "Version ");
        ::strcat(buf, get_version_id());
        u = drv->toUCS2(buf, (int)::strlen(buf), NULL);

        ::SetDlgItemText(hDlg, IDC_VERSION, u);
      }
      return TRUE;
      break;
    }

  case WM_COMMAND:
    if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
    {
      EndDialog(hDlg, LOWORD(wParam));
      return TRUE;
    }
    break;
  }
  return FALSE;
}

void CSTedScreenWin32::discard_device()
{
  ::OutputDebugStringW(L"discard_device()\n");
  graphics_dc_target_[0].Reset();
  graphics_dc_target_[1].Reset();
  text_dc_target_.Reset();
  graphics_bitmap_target_[0].Reset();
  graphics_bitmap_target_[1].Reset();
  text_bitmap_target_.Reset();
  brush_mask_on_.Reset();
  brush_mask_off_.Reset();
  brush_clear_.Reset();
  brush_text_clear_.Reset();
  brush_text_.Reset();

}

void CSTedScreenWin32::create_device()
{

  		// Create a DC render target 
		//D2D1_RENDER_TARGET_PROPERTIES props = D2D1::RenderTargetProperties(
		//	D2D1_RENDER_TARGET_TYPE_DEFAULT,
		//	D2D1::PixelFormat(
		//		DXGI_FORMAT_B8G8R8A8_UNORM,
		//		D2D1_ALPHA_MODE_IGNORE
		//		) , 0.0, 0.0,
		//	D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE
		//	);

		//EXCEPTION_ON_ERROR(factory_->CreateDCRenderTarget(
		//	&props,
		//	&render_target_
		//	));
 
  HRESULT hr = S_OK;
  D2D1_SIZE_F s(D2D1::SizeF(fWindowWidth, fWindowHeight));

	// HwndRenderTargetの作成
  if(!render_target_)
	{

    D2D1_RENDER_TARGET_PROPERTIES rtProps = D2D1::RenderTargetProperties();
    rtProps.usage =  D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE;
		THROW_IF_ERR(factory_->CreateHwndRenderTarget(
			rtProps,
			D2D1::HwndRenderTargetProperties(hwnd_, D2D1::SizeU(fWindowWidth,fWindowHeight),D2D1_PRESENT_OPTIONS_IMMEDIATELY),
			&render_target_
			));

	}

  // バックバッファの作成 
  THROW_IF_ERR(
    render_target_->CreateCompatibleRenderTarget(
      &s,NULL,NULL,D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_GDI_COMPATIBLE,&text_bitmap_target_));
  //text_bitmap_target_->SetAntialiasMode(D2D1_ANTIALIAS_MODE_PER_PRIMITIVE);
  THROW_IF_ERR(
    render_target_->CreateCompatibleRenderTarget(
      &s,NULL,NULL,D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_GDI_COMPATIBLE,&graphics_bitmap_target_[0]));
  THROW_IF_ERR
    (render_target_->CreateCompatibleRenderTarget
        (&s,NULL,NULL,D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_GDI_COMPATIBLE,&graphics_bitmap_target_[1]));

  // GDI描画用のレンダーターゲット 
  THROW_IF_ERR
    (text_bitmap_target_.As( &text_dc_target_));
  THROW_IF_ERR
    (graphics_bitmap_target_[0].As(&graphics_dc_target_[0]));
  THROW_IF_ERR
    (graphics_bitmap_target_[1].As(&text_dc_target_));

  THROW_IF_ERR(
    render_target_->CreateSolidColorBrush
      (D2D1::ColorF(1.0f,1.0f,1.0f),&brush_mask_on_));

  THROW_IF_ERR(
    render_target_->CreateSolidColorBrush
      (D2D1::ColorF(0.0f,0.0f,0.0f),&brush_mask_off_));

  THROW_IF_ERR(
    render_target_->CreateSolidColorBrush
      (D2D1::ColorF(0.0f,0.0f,0.0f,0.0f),&brush_clear_));

  THROW_IF_ERR(
    render_target_->CreateSolidColorBrush
      (D2D1::ColorF(0.0f,0.0f,0.0f,0.0f),&brush_text_clear_));

  THROW_IF_ERR(
    render_target_->CreateSolidColorBrush
      (D2D1::ColorF(1.0f,1.0f,1.0f,1.0f),&brush_text_));

};

void CSTedScreenWin32::create_device_independent_resources()
{
  base_win32_window<>::create_device_independent_resources();
  // Text Formatの作成
  THROW_IF_ERR(write_factory_->CreateTextFormat(
    L"みかちゃん",                // Font family name.
    NULL,                       // Font collection (NULL sets it to use the system font collection).
    DWRITE_FONT_WEIGHT_NORMAL,
    DWRITE_FONT_STYLE_NORMAL,
    DWRITE_FONT_STRETCH_NORMAL,
    fTextLineHeight,
    L"ja-jp",
    &text_fmt_
    ));
}