﻿/* rcdcheck.c

   RCD stay check functions
   compatible to rcdcheck.s

   Made by Studio Breeze. 1998


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include "sted.h"
#include "sted_screen.h"

#define MAX_BAR      2048            /* max size of measure is 2048 */
static int bar_st[TRK_NUM][MAX_BAR];

//struct RCD_HEAD  *rcd;
static char *_data_adr, *_tone_adr, *_word_adr, *_gsd_adr, *_smf_adr;

static void request_midi_data(char *);

static void _start_external_player(void);
static void _stop_external_player(void);
static void _exit_external_player(int);
static void null_func (void) {};
static void null_func_char (char in_a) {};

/** RCD 構造体の初期化を行う コンストラクタのようなもの */
void
rcd_check( void ) {
  int i;
  int alloc_size;

  /* memory allocation */

  alloc_size =
    sizeof(struct RCD_HEAD)+
    sizeof(char)*
    (DATA_ADR_SIZE +
     SMF_ADR_SIZE +
     TONE_ADR_SIZE +
     WORD_ADR_SIZE +
     GSD_ADR_SIZE);

  rcd = (struct RCD_HEAD *)malloc( alloc_size );
  _data_adr = (char *)rcd + sizeof(struct RCD_HEAD);
  _smf_adr  = _data_adr + DATA_ADR_SIZE;
  _tone_adr = _smf_adr  + SMF_ADR_SIZE;
  _word_adr = _tone_adr + TONE_ADR_SIZE;
  _gsd_adr  = _word_adr + WORD_ADR_SIZE;

  rcd_version[0] = '3';
  rcd_version[1] = '.';
  rcd_version[2] = '0';
  rcd_version[3] = '1';

  rcd->title[0] = 'R';
  rcd->title[1] = 'C';
  rcd->title[2] = 'D';
  rcd->title[3] = ' ';

  rcd->version[0] = '3';
  rcd->version[1] = '.';
  rcd->version[2] = '0';
  rcd->version[3] = '1';

  rcd->staymark = 0;

  rcd->data_valid = 1;
  rcd->tone_valid = 0;
  rcd->word_valid = 0;
  rcd->gsd_valid = 0;
  rcd->fmt = 1;

  rcd->data_adr = _data_adr;
  rcd->tone_adr = _tone_adr;
  rcd->word_adr = _word_adr;
  rcd->gsd_adr  = _gsd_adr;
  rcd->smf_adr  = _smf_adr;

  rcd->init  = null_func;              /* RCD initialize ? */
  rcd->setup = null_func;              /* RCD setup routine ? */
  rcd->begin = _start_external_player;  /* start playing RCP data */
  rcd->end = _stop_external_player;    /* stop playing RCP data */

  rcd->md_put = put_midi_data;
  rcd->md_get = get_midi_data;
  rcd->md_put2 = null_func_char;
  rcd->mix_out = request_midi_data;

  rcd->act = 0;
  rcd->sts = 1;
  rcd->tar_trk = 0;
  rcd->tar_bar = 0;

  rcd->dummy1[0] = 0;

  rcd->tempo = 64;
  rcd->basetempo = 64;

  rcd->totalcount = 0;
  rcd->filename[0] = 0;
  rcd->tonename[0] = 0;

  rcd->dummy2[0] = 0;

  rcd->bufcap = DATA_ADR_SIZE;

  rcd->MIDI_avl = 0;
  rcd->MIDI_req[0] = 0;

  for( i=0;i<TRK_NUM;i++ ) {
    rcd->active[i]=1;
    rcd->bar[i]=0;
    rcd->step[i]=0;
  }
  rcd->stepcount = 0;
}

void rcd_open_device( void ) {
  open_midi_device( midi_port_name );
  return;
}

void
_start_external_player(void)
{
    if ( STed_InitMeasureConversion() !=0 ) return;

	start_player((unsigned char *)_data_adr, rcd->totalcount);
}

void
_stop_external_player(void)
{
	stop_player();
}

void
_exit_external_player(int in_sig)
{
	close_player(in_sig);
}

void
request_midi_data(char *in_p)
{
}

 int add_set(int, int*);
 int step_cluc2(int, int, int);
 int meas_add(int);

int
STed_InitMeasureConversion() {

  int i,j;
  int *measure;
  int m;

  for( i=0;i<TRK_NUM;i++ ) {
    rcd->active[i]=1;
    rcd->bar[i]=0;
    rcd->step[i]=0;
  }
  rcd->stepcount = 0;

  measure = (int *)malloc(sizeof(int)*MAX_BAR);
  for ( i=0 ; i<TRK_NUM ; i++ ) {
    m=add_set( i, measure );
    for ( j=0 ; j<m ; j++ ) {
      bar_st[i][j] = step_cluc2( i, 0, measure[j] );
    }
    bar_st[i][m]=-1;
  }
  free(measure);

  return 0;
}

/* converts from total step to measure & relative step */
static int stp_ad( int tr, int meas, int step );
int
STed_MeasureConversion( int tr ) {

  int i;
  int c=rcd->stepcount;

  if ( rcd->bar[tr]>=0 || rcd->step[tr]>=0 ) return 0;

  i=0;
  while (i<MAX_BAR) {
    if ( bar_st[tr][i]>c ) break;
    if ( bar_st[tr][i]<0 ) i=MAX_BAR;
    i++;
  }
  i--;
  
  if ( i==MAX_BAR-1 ) {   /* measures ended */
    rcd->bar[tr]=0;
    rcd->step[tr]=0;
    rcd->active[tr]=0;
  } else {
    rcd->active[tr]=1;
    rcd->bar[tr] = i;
    rcd->step[tr] = stp_ad(tr, i, c-bar_st[tr][i]);
  }

  return 0;
}

static int
stp_ad( int t, int measure, int step ) {

  unsigned char a;
  int po;
  int tr;
  int s;
  unsigned char *bp=trk[t];

  measure+=(poft&0xffff);
  if (( poft&0xffff)==0 ) measure++;
  tr=track;
  track=t;
  po = meas_add(measure);
  track=tr;

  s=1;
  while (step>0) {
  redis:
    a=bp[po];
    if(a==0xf7){po+=4;goto redis;}
    if(a>=0xfc ) break;

    if ( a<0xf0 ) {
      step-=bp[po+1];
      if (step<0) break;
    }
    s++;
    po=po+4;
  }

  return s;
}

