package jp.sourceforge.pdt_tools.variables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.text.ITextSelection;

@SuppressWarnings("restriction")
public class SelectedLineEndVariableResolver implements
		IDynamicVariableResolver {

	public String resolveValue(IDynamicVariable variable, String argument)
			throws CoreException {
		if (DebugUIPlugin.getStandardDisplay().getThread()
				.equals(Thread.currentThread())) {
			return getEndLine();
		} else {
			final String[] text = new String[1];
			DebugUIPlugin.getStandardDisplay().syncExec(new Runnable() {
				public void run() {
					text[0] = getEndLine();
				}
			});
			return text[0];
		}
	}

	protected String getEndLine() {
		ITextSelection selection = SelectedLineUtil.getTextSelection();
		if (selection != null) {
			int endLine = ((ITextSelection) selection).getEndLine();
			if (endLine >= 0) {
				return Integer.toString(endLine + 1);
			}
		}
		return "";
	}

}
