<?php

// Start of sqlite3 v.0.7-dev

class SQLite3  {

	/**
	 * SQLite データベースをオープンする
	 * @link http://www.php.net/manual/ja/sqlite3.open.php
	 * @param filename string <p>
	 * SQLite データベースへのパス。インメモリデータベースを使う場合は :memory: を指定します。
	 * </p>
	 * @param flags int[optional] <p>
	 * SQLite データベースのオープン方法を指定するフラグ。
	 * デフォルトでは SQLITE3_OPEN_READWRITE | SQLITE3_OPEN_CREATE
	 * を使用してオープンします。
	 * <p>
	 * SQLITE3_OPEN_READONLY:
	 * データベースを読み込み専用でオープンする
	 * </p>
	 * @param encryption_key string[optional] <p>
	 * オプションの暗号キー。SQLite データベースの暗号化と復号に使用します。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function open ($filename, $flags = null, $encryption_key = null) {}

	/**
	 * データベースとの接続を閉じる
	 * @link http://www.php.net/manual/ja/sqlite3.close.php
	 * @return bool 成功した場合に TRUE、失敗した場合に FALSE を返します。
	 */
	public function close () {}

	/**
	 * 指定したデータベースに、結果を返さないクエリを実行する
	 * @link http://www.php.net/manual/ja/sqlite3.exec.php
	 * @param query string <p>
	 * 実行したい SQL クエリ (通常は INSERT、UPDATE あるいは DELETE
	 * クエリ)。
	 * </p>
	 * @return bool クエリが成功した場合に TRUE、失敗した場合に FALSE を返します。
	 */
	public function exec ($query) {}

	/**
	 * SQLite3 ライブラリのバージョンを、文字列定数と数値で返す
	 * @link http://www.php.net/manual/ja/sqlite3.version.php
	 * @return array キー "versionString" および
	 * "versionNumber" を持つ連想配列を返します。
	 */
	public static function version () {}

	/**
	 * 直近の INSERT 文でデータベースに追加された行の ID を返す
	 * @link http://www.php.net/manual/ja/sqlite3.lastinsertrowid.php
	 * @return int 直近の INSERT 文でデータベースに追加された行の ID を返します。
	 */
	public function lastInsertRowID () {}

	/**
	 * 直近で失敗した SQLite リクエストの結果コードを数値で返す
	 * @link http://www.php.net/manual/ja/sqlite3.lasterrorcode.php
	 * @return int 直近で失敗した SQLite リクエストの結果コードを数値で返します。
	 */
	public function lastErrorCode () {}

	/**
	 * 直近で失敗した SQLite リクエストについての英文テキストの説明を返す
	 * @link http://www.php.net/manual/ja/sqlite3.lasterrormsg.php
	 * @return string 直近で失敗した SQLite リクエストについての英文テキストの説明を返します。
	 */
	public function lastErrorMsg () {}

	/**
	 * 接続がビジー状態のときのハンドラを設定する
	 * @link http://www.php.net/manual/ja/sqlite3.busytimeout.php
	 * @param msecs int <p>
	 * スリープさせる時間 (ミリ秒)。この値をゼロ以下にすると、
	 * すでに設定されているタイムアウトハンドラを無効にします。
	 * </p>
	 * @return bool 成功した場合に TRUE、失敗した場合に FALSE を返します。
	 */
	public function busyTimeout ($msecs) {}

	/**
	 * SQLite 拡張ライブラリを読み込む
	 * @link http://www.php.net/manual/ja/sqlite3.loadextension.php
	 * @param shared_library string <p>
	 * 読み込みたいライブラリの名前。ライブラリは、設定オプション
	 * sqlite3.extension_dir で指定したディレクトリになければなりません。
	 * </p>
	 * @return bool 拡張ライブラリの読み込みに成功した場合に TRUE、
	 * 失敗した場合に FALSE を返します。
	 */
	public function loadExtension ($shared_library) {}

	/**
	 * 直近の SQL 文で変更 (あるいは挿入、削除) された行の数を返す
	 * @link http://www.php.net/manual/ja/sqlite3.changes.php
	 * @return int 直近の SQL 文で変更 (あるいは挿入、削除) された行の数を表す
	 * integer 値を返します。
	 */
	public function changes () {}

	/**
	 * 適切にエスケープされた文字列を返す
	 * @link http://www.php.net/manual/ja/sqlite3.escapestring.php
	 * @param value string <p>
	 * エスケープしたい文字列。
	 * </p>
	 * @return string SQL 文の中で安全に使えるよう適切にエスケープされた文字列を返します。
	 */
	public static function escapeString ($value) {}

	/**
	 * 実行する SQL 文を準備する
	 * @link http://www.php.net/manual/ja/sqlite3.prepare.php
	 * @param query string <p>
	 * 準備したい SQL クエリ。
	 * </p>
	 * @return SQLite3Stmt 成功した場合に SQLite3Stmt オブジェクト、失敗した場合に FALSE を返します。
	 */
	public function prepare ($query) {}

	/**
	 * SQL クエリを実行する
	 * @link http://www.php.net/manual/ja/sqlite3.query.php
	 * @param query string <p>
	 * 実行したい SQL クエリ。
	 * </p>
	 * @return SQLite3Result クエリが結果を返す場合は SQLite3Result オブジェクトを返します。
	 * それ以外の場合は、成功した場合に TRUE、
	 * 失敗した場合に FALSE を返します。
	 */
	public function query ($query) {}

	/**
	 * クエリを実行し、単一の結果を返す
	 * @link http://www.php.net/manual/ja/sqlite3.querysingle.php
	 * @param query string <p>
	 * 実行したい SQL クエリ。
	 * </p>
	 * @param entire_row bool[optional] <p>
	 * デフォルトでは、querySingle はクエリが返す結果の最初のカラムの値を返します。
	 * entire_row が TRUE の場合は、最初の行全体を配列で返します。
	 * </p>
	 * @return mixed 結果の最初のカラムの値あるいは最初の行全体の配列
	 * (entire_row が TRUE の場合) を返します。
	 * </p>
	 * <p>
	 * クエリ自体は有効であるけれども結果が返されなかった場合の返り値は、
	 * entire_row が FALSE なら NULL、
	 * そうでなければ空の配列となります。
	 * </p>
	 * <p>
	 * クエリが無効な場合やクエリの実行に失敗した場合は FALSE を返します。
	 */
	public function querySingle ($query, $entire_row = null) {}

	/**
	 * SQL のスカラー関数として使用する PHP 関数を登録する
	 * @link http://www.php.net/manual/ja/sqlite3.createfunction.php
	 * @param name string <p>
	 * 作成あるいは再定義したい SQL 関数の名前。
	 * </p>
	 * @param callback mixed <p>
	 * コールバックとして指定する、
	 * PHP の関数あるいはユーザー定義関数の名前。
	 * これが SQL 関数の振る舞いを定義します。
	 * </p>
	 * @param argument_count int[optional] <p>
	 * SQL 関数が受け取るパラメータの数。
	 * 負の値を指定すると、SQL 関数は任意の数の引数を受け取るようになります。
	 * </p>
	 * @return bool 関数の作成に成功した場合に TRUE、失敗した場合に FALSE
	 * を返します。
	 */
	public function createFunction ($name, $callback, $argument_count = null) {}

	/**
	 * SQL の集約関数として使用する PHP 関数を登録する
	 * @link http://www.php.net/manual/ja/sqlite3.createaggregate.php
	 * @param name string <p>
	 * 作成あるいは再定義したい SQL 集約関数の名前。
	 * </p>
	 * @param step_callback mixed <p>
	 * 集約対象のすべての項目に適用するコールバックとして指定する、
	 * PHP の関数あるいはユーザー定義関数の名前。
	 * </p>
	 * @param final_callback mixed <p>
	 * 集約処理の最後に適用するコールバックとして指定する、
	 * PHP の関数あるいはユーザー定義関数の名前。
	 * </p>
	 * @param argument_count int[optional] <p>
	 * SQL 集約関数が受け取るパラメータの数。
	 * 負の値を指定すると、SQL 集約関数は任意の数の引数を受け取るようになります。
	 * </p>
	 * @return bool 集約関数の作成に成功した場合に TRUE、失敗した場合に FALSE
	 * を返します。
	 */
	public function createAggregate ($name, $step_callback, $final_callback, $argument_count = null) {}

	/**
	 * @param name
	 * @param callback
	 */
	public function createCollation ($name, $callback) {}

	/**
	 * @param table
	 * @param column
	 * @param rowid
	 * @param dbname[optional]
	 */
	public function openBlob ($table, $column, $rowid, $dbname) {}

	/**
	 * @param enableExceptions
	 */
	public function enableExceptions ($enableExceptions) {}

	/**
	 * SQLite3 オブジェクトを作成し、SQLite 3 データベースをオープンする
	 * @link http://www.php.net/manual/ja/sqlite3.construct.php
	 * @param filename
	 * @param flags
	 * @param encryption_key
	 */
	public function __construct ($filename, $flags, $encryption_key) {}

}

class SQLite3Stmt  {

	/**
	 * プリペアドステートメント内のパラメータの数を返す
	 * @link http://www.php.net/manual/ja/sqlite3stmt.paramcount.php
	 * @return int プリペアドステートメント内のパラメータの数を返します。
	 */
	public function paramCount () {}

	/**
	 * プリペアドステートメントを閉じる
	 * @link http://www.php.net/manual/ja/sqlite3stmt.close.php
	 * @return bool TRUE を返します。
	 */
	public function close () {}

	/**
	 * プリペアドステートメントをリセットする
	 * @link http://www.php.net/manual/ja/sqlite3stmt.reset.php
	 * @return bool ステートメントのリセットに成功した場合に TRUE、
	 * 失敗した場合に FALSE を返します。
	 */
	public function reset () {}

	/**
	 * 現在バインドされているすべてのパラメータをクリアする
	 * @link http://www.php.net/manual/ja/sqlite3stmt.clear.php
	 * @return bool バインドされているパラメータのクリアに成功した場合に TRUE、
	 * 失敗した場合に FALSE を返します。
	 */
	public function clear () {}

	/**
	 * プリペアドステートメントを実行し、結果セットオブジェクトを返す
	 * @link http://www.php.net/manual/ja/sqlite3stmt.execute.php
	 * @return SQLite3Result プリペアドステートメントの実行に成功した場合に SQLite3Result オブジェクト、
	 * 失敗した場合に FALSE を返します。
	 */
	public function execute () {}

	/**
	 * パラメータを変数にバインドする
	 * @link http://www.php.net/manual/ja/sqlite3stmt.bindparam.php
	 * @param sql_param string <p>
	 * パラメータをどの変数にバインドするかを表す文字列。
	 * </p>
	 * @param param mixed <p>
	 * 変数にバインドするパラメータ。
	 * </p>
	 * @param type int[optional] <p>
	 * バインドするパラメータのデータ型。
	 * <p>
	 * SQLITE3_INTEGER: 符号付き整数。
	 * 値の大きさに応じて 1, 2, 3, 4, 6, あるいは 8 バイトで格納されます。
	 * </p>
	 * @return bool パラメータを変数にバインドした場合に TRUE、
	 * 失敗した場合に FALSE を返します。
	 */
	public function bindParam ($sql_param, &$param, $type = null) {}

	/**
	 * パラメータの値を変数にバインドする
	 * @link http://www.php.net/manual/ja/sqlite3stmt.bindvalue.php
	 * @param sql_param string <p>
	 * 値をどの変数にバインドするかを表す文字列。
	 * </p>
	 * @param value mixed <p>
	 * 変数にバインドする値。
	 * </p>
	 * @param type int[optional] <p>
	 * バインドする値のデータ型。
	 * <p>
	 * SQLITE3_INTEGER: 符号付き整数。
	 * 値の大きさに応じて 1, 2, 3, 4, 6, あるいは 8 バイトで格納されます。
	 * </p>
	 * @return bool 値を変数にバインドした場合に TRUE、
	 * 失敗した場合に FALSE を返します。
	 */
	public function bindValue ($sql_param, $value, $type = null) {}

	public function readOnly () {}

	/**
	 * @param sqlite3
	 */
	private function __construct ($sqlite3) {}

}

class SQLite3Result  {

	/**
	 * 結果セットのカラム数を返す
	 * @link http://www.php.net/manual/ja/sqlite3result.numcolumns.php
	 * @return int 結果セットのカラム数を返します。
	 */
	public function numColumns () {}

	/**
	 * n 番目のカラムの名前を返す
	 * @link http://www.php.net/manual/ja/sqlite3result.columnname.php
	 * @param column_number int <p>
	 * 0 から始まるカラムの数値インデックス。
	 * </p>
	 * @return string column_number で指定したカラムの名前を文字列で返します。
	 */
	public function columnName ($column_number) {}

	/**
	 * n 番目のカラムの型を返す
	 * @link http://www.php.net/manual/ja/sqlite3result.columntype.php
	 * @param column_number int <p>
	 * 0 から始まるカラムの数値インデックス。
	 * </p>
	 * @return int column_number で指定したカラムのデータ型インデックス
	 * (SQLITE3_INTEGER、SQLITE3_FLOAT、
	 * SQLITE3_TEXT、SQLITE3_BLOB あるいは
	 * SQLITE3_NULL のいずれか)
	 * を返します。
	 */
	public function columnType ($column_number) {}

	/**
	 * 結果の行を、連想配列あるいは数値添字配列あるいはその両方で取得する
	 * @link http://www.php.net/manual/ja/sqlite3result.fetcharray.php
	 * @param mode int[optional] <p>
	 * 次の行をどのように返すかを制御します。値は
	 * SQLITE3_ASSOC か
	 * SQLITE3_NUM、SQLITE3_BOTH
	 * のいずれかでなければなりません。
	 * <p>
	 * SQLITE3_ASSOC:
	 * 返された結果セットのカラム名をインデックスとする配列を返します。
	 * </p>
	 * @return array 結果の行を、連想配列あるいは数値添字配列あるいはその両方で取得します。
	 * 行がない場合は FALSE を返します。
	 */
	public function fetchArray ($mode = null) {}

	/**
	 * 結果セットを最初の行に戻す
	 * @link http://www.php.net/manual/ja/sqlite3result.reset.php
	 * @return bool 結果セットを最初の行に戻すことに成功した場合に TRUE、
	 * 失敗した場合に FALSE を返します。
	 */
	public function reset () {}

	/**
	 * 結果セットを閉じる
	 * @link http://www.php.net/manual/ja/sqlite3result.finalize.php
	 * @return bool TRUE を返します。
	 */
	public function finalize () {}

	private function __construct () {}

}

/**
 * SQLite3_result::fetchArray が返す結果セットが、
 * カラム名をインデックスとする配列であることを指定します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_ASSOC', 1);

/**
 * SQLite3_result::fetchArray が返す結果セットが、
 * カラム番号をインデックスとする配列であることを指定します。
 * カラム番号は 0 からはじまります。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_NUM', 2);

/**
 * SQLite3_result::fetchArray が返す結果セットが、
 * カラム名とカラム番号の両方をインデックスとする配列であることを指定します。
 * カラム番号は 0 からはじまります。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_BOTH', 3);

/**
 * SQLite3 INTEGER 型を表します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_INTEGER', 1);

/**
 * SQLite3 REAL (FLOAT) 型を表します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_FLOAT', 2);

/**
 * SQLite3 TEXT 型を表します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_TEXT', 3);

/**
 * SQLite3 BLOB 型を表します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_BLOB', 4);

/**
 * SQLite3 NULL 型を表します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_NULL', 5);

/**
 * SQLite3 データベースを読み込み専用でオープンすることを指定します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_OPEN_READONLY', 1);

/**
 * SQLite3 データベースを読み書き両用でオープンすることを指定します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_OPEN_READWRITE', 2);

/**
 * データベースが存在しない場合に SQLite3 データベースを新規作成することを指定します。
 * @link http://www.php.net/manual/ja/sqlite3.constants.php
 */
define ('SQLITE3_OPEN_CREATE', 4);

// End of sqlite3 v.0.7-dev
?>
