<?php

// Start of json v.1.2.1

/**
 * 値を JSON 形式にして返す
 * @link http://www.php.net/manual/ja/function.json-encode.php
 * @param value mixed <p>
 * エンコードする値。
 * resource 型以外の任意の型を指定できます。
 * </p>
 * <p>
 * この関数は、UTF-8 エンコードされたデータでのみ動作します。
 * </p>
 * @param options int[optional] <p>
 * JSON_HEX_QUOT,
 * JSON_HEX_TAG,
 * JSON_HEX_AMP,
 * JSON_HEX_APOS,
 * JSON_NUMERIC_CHECK,
 * JSON_PRETTY_PRINT,
 * JSON_UNESCAPED_SLASHES,
 * JSON_FORCE_OBJECT,
 * JSON_UNESCAPED_UNICODE
 * からなるビットマスク。
 * 各定数の意味については
 * JSON 定数のページ
 * に説明があります。
 * </p>
 * @param depth int[optional] 
 * @return string 成功した場合に、JSON エンコードされた文字列を返します。
 * 失敗した場合に FALSE を返します。
 */
function json_encode ($value, $options = null, $depth = null) {}

/**
 * JSON 文字列をデコードする
 * @link http://www.php.net/manual/ja/function.json-decode.php
 * @param json string <p>
 * デコード対象となる json 文字列。
 * </p>
 * <p>
 * この関数は UTF-8 でエンコードされたデータでのみ動作します。
 * </p>
 * @param assoc bool[optional] <p>
 * TRUE の場合、返されるオブジェクトは連想配列形式になります。
 * </p>
 * @param depth int[optional] <p>
 * ユーザー指定の再帰の深さ。
 * </p>
 * @param options int[optional] <p>
 * JSON デコードオプションのビットマスクです。現在サポートされるオプションは
 * JSON_BIGINT_AS_STRING のみです
 * (デフォルトでは、大きな整数値を float に変換します)。
 * </p>
 * @return mixed json でエンコードされたデータを、適切な PHP の型として返します。
 * true、false および
 * null (大文字小文字を区別しません) はそれぞれ TRUE、FALSE
 * そして NULL として返されます。
 * json のデコードに失敗したり
 * エンコードされたデータが再帰制限を超えているなどの場合、NULL を返します。
 */
function json_decode ($json, $assoc = null, $depth = null, $options = null) {}

/**
 * 直近に発生したエラーを返す
 * @link http://www.php.net/manual/ja/function.json-last-error.php
 * @return int 整数値を返します。これは、次の定数のいずれかとなります。
 */
function json_last_error () {}


/**
 * すべての &lt; および &gt; をそれぞれ \u003C および \u003E に変換します。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_HEX_TAG', 1);

/**
 * すべての &amp; を \u0026 に変換します。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_HEX_AMP', 2);

/**
 * すべての ' を \u0027 に変換します。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_HEX_APOS', 4);

/**
 * すべての " を \u0022 に変換します。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_HEX_QUOT', 8);

/**
 * 非連想配列を使用した場合に、配列ではなくオブジェクトを出力します。
 * 出力を受け取る側がオブジェクトを期待しており、配列が空っぽである場合などに特に便利です。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_FORCE_OBJECT', 16);

/**
 * 数値形式の文字列を数値としてエンコードします。
 * PHP 5.3.3 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_NUMERIC_CHECK', 32);

/**
 * エラーが発生しませんでした。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_ERROR_NONE', 0);

/**
 * スタックの深さが最大に達しました。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_ERROR_DEPTH', 1);

/**
 * アンダーフローあるいはモードの不一致が発生しました。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_ERROR_STATE_MISMATCH', 2);

/**
 * 制御文字エラー。おそらくエンコードが間違っています。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_ERROR_CTRL_CHAR', 3);

/**
 * 構文エラー。
 * この定数は PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_ERROR_SYNTAX', 4);

/**
 * 正しくエンコードされていないなど、不正な形式の UTF-8 文字。
 * この定数は PHP 5.3.3 以降で使用可能です。
 * @link http://www.php.net/manual/ja/json.constants.php
 */
define ('JSON_ERROR_UTF8', 5);

// End of json v.1.2.1
?>
