<?php

// Start of xmlreader v.0.1

class XMLReader  {
	const NONE = 0;
	const ELEMENT = 1;
	const ATTRIBUTE = 2;
	const TEXT = 3;
	const CDATA = 4;
	const ENTITY_REF = 5;
	const ENTITY = 6;
	const PI = 7;
	const COMMENT = 8;
	const DOC = 9;
	const DOC_TYPE = 10;
	const DOC_FRAGMENT = 11;
	const NOTATION = 12;
	const WHITESPACE = 13;
	const SIGNIFICANT_WHITESPACE = 14;
	const END_ELEMENT = 15;
	const END_ENTITY = 16;
	const XML_DECLARATION = 17;
	const LOADDTD = 1;
	const DEFAULTATTRS = 2;
	const VALIDATE = 3;
	const SUBST_ENTITIES = 4;


	/**
	 * XMLReader の入力を閉じる
	 * @link http://www.php.net/manual/ja/xmlreader.close.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function close () {}

	/**
	 * 名前をもとに、属性の値を取得する
	 * @link http://www.php.net/manual/ja/xmlreader.getattribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @return string 属性の値を返します。指定した名前 name の
	 * 属性が見つからなかったり、現在位置が要素ノードではなかったりした場合には
	 * NULL を返します。
	 */
	public function getAttribute ($name) {}

	/**
	 * インデックスをもとに、属性の値を取得する
	 * @link http://www.php.net/manual/ja/xmlreader.getattributeno.php
	 * @param index int <p>
	 * 属性の位置。
	 * </p>
	 * @return string 属性の値を返します。指定した位置 index に
	 * 属性が見つからなかったり、現在位置が要素ではなかったりした場合には
	 * 空の文字列を返します。
	 */
	public function getAttributeNo ($index) {}

	/**
	 * 名前および URI をもとに、属性の値を取得する
	 * @link http://www.php.net/manual/ja/xmlreader.getattributens.php
	 * @param localName string <p>
	 * ローカルの名前。
	 * </p>
	 * @param namespaceURI string <p>
	 * 名前空間の URI。
	 * </p>
	 * @return string 属性の値を返します。指定した localName
	 * および namespaceURI に属性が見つからなかったり、
	 * 現在位置が要素ではなかったりした場合には空の文字列を返します。
	 */
	public function getAttributeNs ($localName, $namespaceURI) {}

	/**
	 * 指定したプロパティが設定されているかどうかを示す
	 * @link http://www.php.net/manual/ja/xmlreader.getparserproperty.php
	 * @param property int <p>
	 * パーサオプション定数
	 * のうちのひとつ。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function getParserProperty ($property) {}

	/**
	 * パースしているドキュメントの妥当性を示す
	 * @link http://www.php.net/manual/ja/xmlreader.isvalid.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isValid () {}

	/**
	 * プレフィックスから、名前空間を検索する
	 * @link http://www.php.net/manual/ja/xmlreader.lookupnamespace.php
	 * @param prefix string <p>
	 * プレフィックスを含む文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function lookupNamespace ($prefix) {}

	/**
	 * 指定したインデックスの属性にカーソルを移動する
	 * @link http://www.php.net/manual/ja/xmlreader.movetoattributeno.php
	 * @param index int <p>
	 * 属性の位置。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function moveToAttributeNo ($index) {}

	/**
	 * 指定した名前の属性にカーソルを移動する
	 * @link http://www.php.net/manual/ja/xmlreader.movetoattribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function moveToAttribute ($name) {}

	/**
	 * 指定した名前の属性にカーソルを移動する
	 * @link http://www.php.net/manual/ja/xmlreader.movetoattributens.php
	 * @param localName string <p>
	 * ローカル名。
	 * </p>
	 * @param namespaceURI string <p>
	 * 名前空間の URI。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function moveToAttributeNs ($localName, $namespaceURI) {}

	/**
	 * 現在の属性の親要素にカーソルを移動する
	 * @link http://www.php.net/manual/ja/xmlreader.movetoelement.php
	 * @return bool 成功した場合に TRUE、失敗した場合、
	 * あるいはメソッドがコールされた際の位置が属性ノードではなかった場合に
	 * FALSE を返します。
	 */
	public function moveToElement () {}

	/**
	 * 最初の属性にカーソルを移動する
	 * @link http://www.php.net/manual/ja/xmlreader.movetofirstattribute.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function moveToFirstAttribute () {}

	/**
	 * 次の属性にカーソルを移動する
	 * @link http://www.php.net/manual/ja/xmlreader.movetonextattribute.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function moveToNextAttribute () {}

	/**
	 * パースする XML を含む URI を設定する
	 * @link http://www.php.net/manual/ja/xmlreader.open.php
	 * @param URI string <p>
	 * ドキュメントを指す URI。
	 * </p>
	 * @param encoding string[optional] <p>
	 * ドキュメントのエンコーディングあるいは NULL。
	 * </p>
	 * @param options int[optional] <p>
	 * LIBXML_* 定数のビットマスク。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * 静的にコールされた場合には XMLReader を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function open ($URI, $encoding = null, $options = null) {}

	/**
	 * ドキュメント内の次のノードに移動する
	 * @link http://www.php.net/manual/ja/xmlreader.read.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function read () {}

	/**
	 * すべてのサブツリーを飛ばして、次のノードにカーソルを移動する
	 * @link http://www.php.net/manual/ja/xmlreader.next.php
	 * @param localname string[optional] <p>
	 * 移動先のノードの名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function next ($localname = null) {}

	/**
	 * 現在のノードから XML を取得する
	 * @link http://www.php.net/manual/ja/xmlreader.readinnerxml.php
	 * @return string 現在のノードの中身を文字列で返します。失敗した場合は空文字列を返します。
	 */
	public function readInnerXml () {}

	/**
	 * 現在のノードから自分自身も含めた XML を取得する
	 * @link http://www.php.net/manual/ja/xmlreader.readouterxml.php
	 * @return string 現在のノードの中身を、自分自身も含めて文字列で返します。失敗した場合は空文字列を返します。
	 */
	public function readOuterXml () {}

	/**
	 * 現在のノードの内容を文字列で読み込む
	 * @link http://www.php.net/manual/ja/xmlreader.readstring.php
	 * @return string 現在のノードの内容を文字列で返します。失敗した場合は空文字列を返します。
	 */
	public function readString () {}

	/**
	 * ドキュメントを XSD で検証する
	 * @link http://www.php.net/manual/ja/xmlreader.setschema.php
	 * @param filename string <p>
	 * XSD スキーマファイル名。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setSchema ($filename) {}

	/**
	 * パーサのオプションを設定する
	 * @link http://www.php.net/manual/ja/xmlreader.setparserproperty.php
	 * @param property int <p>
	 * パーサオプション定数
	 * のひとつ。
	 * </p>
	 * @param value bool <p>
	 * TRUE を設定するとオプションが有効になり、それ以外を設定すると
	 * 無効になります。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setParserProperty ($property, $value) {}

	/**
	 * RelaxNG スキーマのファイル名あるいは URI を設定する
	 * @link http://www.php.net/manual/ja/xmlreader.setrelaxngschema.php
	 * @param filename string <p>
	 * RelaxNG スキーマを指すファイル名あるいは URI。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setRelaxNGSchema ($filename) {}

	/**
	 * RelaxNG スキーマを含むデータを設定する
	 * @link http://www.php.net/manual/ja/xmlreader.setrelaxngschemasource.php
	 * @param source string <p>
	 * RelaxNG スキーマを含む文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setRelaxNGSchemaSource ($source) {}

	/**
	 * パースする XML を含むデータを設定する
	 * @link http://www.php.net/manual/ja/xmlreader.xml.php
	 * @param source string <p>
	 * パースされる XML を含む文字列。
	 * </p>
	 * @param encoding string[optional] <p>
	 * ドキュメントのエンコーディングあるいは NULL。
	 * </p>
	 * @param options int[optional] <p>
	 * LIBXML_* 定数のビットマスク。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * 静的にコールされた場合には XMLReader を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function XML ($source, $encoding = null, $options = null) {}

	/**
	 * 現在のノードのコピーを DOM オブジェクトとして返す
	 * @link http://www.php.net/manual/ja/xmlreader.expand.php
	 * @param basenode DOMNode[optional] 
	 * @return DOMNode DOMNode か、エラー時には FALSE を返します。
	 */
	public function expand (DOMNode $basenode = null) {}

}
// End of xmlreader v.0.1
?>
