/*
 * OpenI2CRADIO
 * Idle routine.
 * Using timer0.
 * (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2
 */
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <signal.h>
#include "iodef.h"


void idle_init(void)
{
   INTCON = _TMR0IE & ~(_TMR0IF | _INT0IF | _RBIF); // Enable tmr0 as interrupt and clear interrupt flags.
   INTCON2 = ~_TMR0IP & _TMR0IP; // Interrupt is lower.
   WDTCON = 0; // OK? WDT=Disabled.
}


void stop_idle(void)
{
    T0CONbits.TMR0ON = 0;
}


void idle(unsigned int initial)
{
   unsigned char osccon;
   unsigned char  contword;

   /* Enable IDLE */
   osccon = OSCCON;
   osccon = osccon | _IDLEN |  _SCS1 | _SCS0;
   OSCCON = osccon;
   
   /* Set TMR0 for interrupt*/
   /* Pre-scaler: 1/16, PSA=0(ON), TOSE=0, T0CS=0(INTERNAL), T08BIT=1(8bit), TMR0ON=1(START) */
   contword = _T0PS0 | _T0PS1 | _T08BIT | _TMR0ON; // _T0PS2
   TMR0H = initial >> 8;
   TMR0L = initial & 0xff;
   T0CON = contword;
   
   Sleep();
}
