/*
 * OpenI2CRADIO
 * I2C-LCD ACM1602 Handler
 * (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2
 */

#include "lcd_acm1602.h"

static void sendcmd(unsigned char addr, unsigned char cmd)
{
    i2c_idle();
    OPENASMASTER();
    i2c_writechar(addr);
    i2c_writechar(0x00);
    i2c_writechar(cmd);
    CLOSEASMASTER();
    delay1ktcy(1); // 0.1ms
}

static void delay_lcd(void)
{
    delay1ktcy(40); // (1000cycle * (8*5) = 5ms
}

void acm1602_cls(unsigned char addr)
{
    i2c_idle();
    OPENASMASTER();
    i2c_writechar(addr);
    i2c_writechar(0x00); // CMD
    i2c_writechar(0x01); // CLS
    CLOSEASMASTER();
    delay_lcd();
}

void acm1602_putchar(unsigned char addr, unsigned char c)
{
    i2c_idle();
    OPENASMASTER();
    i2c_writechar(addr);
    i2c_writechar(0x80); //Data
    i2c_writechar(c); // Putchar
    CLOSEASMASTER();
    delay1ktcy(1); //0.1ms
}

void acm1602_locate(unsigned char addr, char x, char y)
{
    unsigned char ramaddr;
    if((x < 0) || (x > 15)) return;
    if((y < 0) || (y > 1)) return;
    if(y == 0){
        ramaddr = 0x80 | (x & 0x0f);
    } else {
        ramaddr = 0xc0 | (x & 0x0f);
    }
    sendcmd(addr, ramaddr);
}

void acm1602_home(unsigned char addr)
{
    i2c_idle();
    OPENASMASTER();
    i2c_writechar(addr);
    i2c_writechar(0x00); // CMD
    i2c_writechar(0x02); // HOME
    CLOSEASMASTER();
    delay_lcd();
}

void acm1602_printf(unsigned char addr, const char *fmt, ...)
{
    char strbuf[32]; // Max 32 bytes.
    va_list args;
    int i;
    int l;

    strbuf[0] = '\0';
    va_start(args, fmt );
    sprintf(strbuf, args);
    l = strlen(strbuf);
    if((l >= 32) || (l <= 0))return;
    for(i = 0; i < l; i++) {
        acm1602_putchar(addr, strbuf[i]);
    }
}

void acm1602_cursordir(unsigned char addr, unsigned char right)
{
    unsigned char cmd;
    if(right == 0) {
        cmd = 0x18;
    } else {
        cmd=0x1c;
    }
    sendcmd(addr, cmd);
}

void acm1602_init(unsigned char addr, unsigned char cls)
{
    sendcmd(addr, 0x38); // 2lines, 8x10dot fonts.
    sendcmd(addr, 0x0f); // Display ON.
    if(cls == 0){
        acm1602_home(addr);
    } else {
        acm1602_cls(addr);
    }
}