#ifndef PLAYSEQUENCETHREAD_H
#define PLAYSEQUENCETHREAD_H

#include <QWidget> // WId
#include <QThread>
#include <QQueue>
#include <QTimer>
#include <QString>

#include "PlayMusicThread.h"

class PlaySequenceThread : public QThread
{
    Q_OBJECT

public:
    PlaySequenceThread(WId winId);
    ~PlaySequenceThread();
    void stop();

    void SetPlayNumList(QList<int> *);
    void SetMusicDir(const QString &dirpath);
    void SetPlaySetting(int slctvoice, int Wait1Time_sec, int Wait2Time_sec);
    int GetPlayStatus();
    int GetPlayFudaNum();
    void Start();
    void Abort();
    void Pause();

signals:
    void SequencStartded();
    void Music1Starteded(int fudaNum);
    void Music1Ended();
    void Music2Starteded(int fudaNum);
    void Music2Ended();
    void SequenceEnded(int status); // status 0 is success, !0 is Fail

private slots:
    void PlayStarted(const QString &filename);
    void PlayEnded();
    void TimeoutDone();

protected:
    void run();
    QString GetMusicFilePath(int FudaN, int KamiShimo);
    void AbortProc();

private:
    volatile bool stopped;

    // State Machine, state Id
    enum { IDLE = 0,
           PLAY_1, // 1 Kami no ku yomiage
           WAIT_1, // 2 wait
           PLAY_2, // 3 Simo no ku yomiage
           WAIT_2, // 4 next wait
           PAUSE
         } state, prev_state;
    // State Machine, event Id
    enum { Ev_Nop = 0,
           Ev_Start,
           Ev_PlayEnd,
           Ev_TimeoutDone,
           Ev_Abort,
           Ev_Pause
         };

    QQueue<int> *EvtQue; // EventQue

    int SelectVoice; // SelectVoice, 0 or 1
    QString MusicFolderName1; // "Music"
    QString MusicFolderName2; // "Music2"
    QString fnamefmt1; // filename format, "yamajun_%03d_%1d.ogg"
    QString fnamefmt2; // filename format, "inaba_%03d_%1d.ogg"
    QString MusicFileDirPath;
    QString fnamefmt;  // filename format
    int ListIndex;
    int PlayListCount;
    QList<int> *PlayNumList;

    int Wait1_sec;
    int Wait2_sec;

    PlayMusicThread *playmusicTh; // real play-music(1file) task

};


#endif // PLAYSEQUENCETHREAD_H
