/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Nmea
{
    /// <summary>
    ///     GNSS DOP and Active Satellites
    /// </summary>
    public class GpGsa : Packet
    {
        #region fields

        private static readonly byte[] header;
        private const int elementNum = 17;

        #endregion

        #region constructors
        
        static GpGsa()
        {
            header = Encoding.ASCII.GetBytes("$GPGSA,");
        }
        
        public GpGsa()
        {
        }

        public GpGsa(byte[] sentence)
            : this(sentence, GetElements(sentence, elementNum))
        {
        }

        private GpGsa(byte[] sentence, Elements elements)
        {
            Raw = new byte[elements.PacketLength];
            Array.Copy(sentence, Raw, elements.PacketLength);
            string[] v = elements.Values;
        }

        #endregion

        #region properties

        #endregion

        #region public method

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, header, elementNum, Build);
        }

        #endregion

        #region private method

        private static Packet Build(byte[] sentence, Elements elements)
        {
            return new GpGsa(sentence, elements);
        }

        #endregion
    }
}