﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class NavVelNed : Packet
    {
        #region constructors

        public NavVelNed(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public decimal TimeOfWeek
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 0) * 1e-3m;
            }
        }

        public EnuVelocity Velocity
        {
            get
            {
                int n = BitConverter.ToInt32(Raw, 6 + 4);
                int e = BitConverter.ToInt32(Raw, 6 + 8);
                int d = -BitConverter.ToInt32(Raw, 6 + 12);
                return new EnuVelocity(e * 0.01, n * 0.01, -d * 0.01);
            }
        }

        public double Speed
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 16) * 0.01;
            }
        }

        public double GroundSpeed
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 20) * 0.01;
            }
        }

        public Degree Heading
        {
            get
            {
                return BitConverter.ToInt32(Raw, 6 + 24) * 1e-5;
            }
        }

        public double SpeedAccuracy
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 28) * 0.01;
            }
        }

        public Degree HeadingAccuracy
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 32) * 1e-5;
            }
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, 
                                            MessageID.NavVelNed, 36, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new NavVelNed(sentence, length);
        }

        #endregion
    }
}
