﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class NavClock : Packet
    {
        #region constructors

        public NavClock(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public decimal TimeOfWeek
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 0) * 1e-3m;
            }
        }

        public decimal ClockBias
        {
            get
            {
                return BitConverter.ToInt32(Raw, 6 + 4) * 1e-9m;
            }
        }

        public decimal ClockDrift
        {
            get
            {
                return BitConverter.ToInt32(Raw, 6 + 8) * 1e-9m;
            }
        }

        public decimal TimeAccuracy
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 12) * 1e-9m;
            }
        }

        public decimal FrequencyAccuracy
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 16) * 1e-6m;
            }
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, MessageID.NavClock, 20, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new NavClock(sentence, length);
        }

        #endregion
    }
}
