﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi
{
    public static class Constants
    {
        #region type definitions
        public static class Wgs84
        {
            public const double SemiMajorAxisA = 6378137.00000;
            public const double SemiMajorAxisB = 6356752.31425;
            public const double FirstEccentricitySquared = 6.69437999013e-3;
            public const double SecondEccentricitySquared = 6.73949674226e-3;
            public const double InverseFlattening = 298.257223563;
            public const double Flattening = 3.3528106647474807e-3;
            public const double Pi = 3.1415926535898;
            public const double SpeedOfLight = 299792458; 
        }

        public static class Grs80
        {
            public const double SemiMajorAxisA = 6378137.00000;
            public const double SemiMajorAxisB = 6356752.31414;
            public const double FirstEccentricitySquared = 6.69438002290e-3;
            public const double SecondEccentricitySquared = 6.73949677548e-3;
            public const double InverseFlattening = 298.257222101;
            public const double Flattening = 3.3528106811823189e-3;
        }

        public static class Bessel
        {
        }
        #endregion
    }
}
