﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using Yubeshi;
using NUnit.Framework;

namespace YubeshiTest
{
    public class ParserTest
    {
        private static OctetString noise;
        
        static ParserTest()
        {
            noise = new OctetString(100);
            for (int i = 0; i < noise.Length; ++i)
            {
                noise[i] = (byte)(i & 0x7F | 0x80);
            }
            noise[52, -1] = NmeaTest.SamplePackets.Dummy;
            noise[79, -1] = UbxTest.SamplePackets.Dummy;
        }

        [Test]
        public void Noise()
        {
            Parser parser = new Parser();
            UnknownPacket p;

            parser.Push(noise);

            p = parser.Peek();
            Assert.IsNull(p);
        }

        [Test]
        public void NoisePacketsNoise()
        {
            Parser parser = new Parser();
            UnknownPacket p;

            OctetString data = noise;
            data += NmeaTest.SamplePackets.GpDtm;
            data += UbxTest.SamplePackets.NavClock;
            data += noise;

            parser.Push(data);

            int length = 0;
            while (null != (p = parser.Peek()))
            {
                if (p is Yubeshi.Nmea.GpDtm)
                {
                    break;
                }
                Assert.IsTrue(p is UnknownPacket);
                length += p.Raw.Length;
            }
            Assert.AreEqual(noise.Length, length);

            Assert.IsTrue(p is Yubeshi.Nmea.GpDtm);

            p = parser.Peek();
            Assert.IsTrue(p is Yubeshi.Ubx.NavClock);

            p = parser.Peek();
            Assert.IsNull(p);
        }
    }
}
