﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class Unknown : Packet
    {
        #region constructors

        public Unknown(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            packet = null;
            if (sentence.Length < 8)
            {
                return false;
            }
            MessageID id = (MessageID)(sentence[2] << 8 | sentence[3]);
            int length = BitConverter.ToUInt16(sentence, 4);
            return TryParse(sentence, out packet, id, length, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new Unknown(sentence, length);
        }

        #endregion
    }
}
