﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class RxmSfrB : Packet
    {
        #region constructors

        public RxmSfrB(byte[] sentence, int length)
            : base(sentence, length)
        {
            Subframe = new uint[10];
            for(int i = 0; i < Subframe.Length; ++i)
            {
                Subframe[i] = BitConverter.ToUInt32(Raw, 8 + 4 * i);
            }
        }

        #endregion

        #region properties

        public int Channel
        {
            get
            {
                return Raw[6 + 0];
            }
        }

        public int SatelliteID
        {
            get
            {
                return Raw[6 + 1];
            }
        }

        public uint[] Subframe
        {
            get;
            private set;
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, 
                                                MessageID.RxmSfrB, 42, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new RxmSfrB(sentence, length);
        }

        #endregion
    }
}
