﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class NavSbas : Packet
    {
        #region type definitions

        public enum SbasMode : byte
        {
            Disabled = 0,
            IntegrityEnabled = 1,
            TestModeEnabled = 3,
        }

        public enum SbasSystem : sbyte
        {
            Unknown = -1,
            Waas = 0,
            Egnos = 1,
            Msas = 2,
            Gps = 16,
        }

        public struct SbasStatus
        { 
            private byte[] Raw;
        }
        #endregion

        #region constructors

        public NavSbas(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public decimal TimeOfWeek
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 0) * 1e-3m;
            }
        }

        public int SbasID
        {
            get
            {
                return Raw[6 + 4];
            }
        }

        public SbasMode Mode
        {
            get
            {
                return (SbasMode)Raw[6 + 5];
            }
        }

        public SbasSystem System
        {
            get
            {
                return (SbasSystem)Raw[6 + 6];
            }
        }

        public int NumberOfSvData
        {
            get
            {
                return Raw[6 + 8];
            }
        }

        public SbasStatus[] Status
        {
            get;
            private set;
        }
        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            packet = null;
            if (sentence.Length < 20)
            {
                return false;
            }
            int length = 12 + 12 * sentence[6 + 8];
            return TryParse(sentence, out packet, 
                                        MessageID.NavSbas, length, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new NavSbas(sentence, length);
        }

        #endregion
    }
}
