package jp.gr.java_conf.ykhr.eclipse.plugin.maid;

import jp.gr.java_conf.ykhr.eclipse.plugin.warninger.core.IWarningerAction;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class MaidJavaWarninger implements IWarningerAction {
    
    private static final int NO_SEVERITY = -1;
    
    public boolean isTarget(IFile file) throws CoreException {
        return "java".equalsIgnoreCase(file.getFileExtension());
    }
    
    public void doAction(IFile file) throws CoreException {
        int highestSeverity = getHighestSeverity(file);
        openMessage(highestSeverity);
    }

    private void openMessage(int severity) {
        String message = null;
        
        switch (severity) {
        case NO_SEVERITY:
            message = "llAł`";
            break;
        case IMarker.SEVERITY_INFO:
        case IMarker.SEVERITY_WARNING:
            message = "ƏłAll";
            break;
        case IMarker.SEVERITY_ERROR:
            message = "܂܂ł`A΂Ăll";
            break;
        }
        
        if (message != null) {
            final String maidMessage = message;
            Display.getDefault().asyncExec(new Runnable() {
                public void run() {
                    MessageDialog.openInformation(Activator.getShell(), "Ch", maidMessage);
                }
            });
        }
    }

    private int getHighestSeverity(IFile file) throws CoreException {
        int highestSeverity = NO_SEVERITY;
        IMarker[] markers = file.findMarkers("org.eclipse.jdt.core.problem", true, IResource.DEPTH_INFINITE);
        for (IMarker marker : markers) {
            int severity = marker.getAttribute(IMarker.SEVERITY, IMarker.SEVERITY_INFO);
            if (severity > highestSeverity) {
                highestSeverity = severity;
            }
        }
        return highestSeverity;
    }

}
