package jp.gr.java_conf.ykhr.listfindbugs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FindbugsHandler extends DefaultHandler {
    
    private List<DecoratorVo> decorators = new ArrayList<DecoratorVo>();
    private Map<String, BugPatternVo> bugPatterns = new HashMap<String, BugPatternVo>();
    
    public List<DecoratorVo> getDecorators() {
        return decorators;
    }
    
    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("Detector".equals(name)) {
            readDecorator(attributes);
        } else if ("BugPattern".equals(name)) {
            readBugPattern(attributes);
        }
    }
    
    @Override
    public void endDocument() throws SAXException {
        for (DecoratorVo decorator : decorators) {
            String[] reports = decorator.getReports();
            for (String report : reports) {
                BugPatternVo bugPattern = bugPatterns.get(report);
                if (bugPattern != null) {
                    decorator.addBugPattern(bugPattern);
                }
            }
        }
    }

    private void readBugPattern(Attributes attributes) {
        String abbrev = attributes.getValue("abbrev");
        String type = attributes.getValue("type");
        String category = attributes.getValue("category");
        
        BugPatternVo bugPattern = new BugPatternVo(type, abbrev, category);
        bugPatterns.put(type, bugPattern);
    }

    private void readDecorator(Attributes attributes) {
        String className = attributes.getValue("class");
        String reports = attributes.getValue("reports");
        if (reports == null || reports.length() == 0) {
            return;
        }
        
        String[] reportArray = reports.split(",");
        String hidden = attributes.getValue("hidden");
        DecoratorVo vo =  new DecoratorVo(className, reportArray, Boolean.valueOf(hidden).booleanValue());
        decorators.add(vo);
    }

}
