package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter;

import java.io.File;

import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class JUnitReporterActivator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter";

	// The shared instance
	private static JUnitReporterActivator plugin;
    
    private static final String ANT_XSL_DIR = "etc";
    
	/**
	 * The constructor
	 */
	public JUnitReporterActivator() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}
    
	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static JUnitReporterActivator getDefault() {
		return plugin;
	}
    
    public static void logError(Throwable t, String message) {
        log(new Status(IStatus.ERROR, PLUGIN_ID, 0, message, t));
    }
    
    public static void logError(Throwable t) {
        logError(t, "Error");
    }
    
    public static void log(IStatus status) {
        getDefault().getLog().log(status);
    }
    
    public static File getAntStyle(String fileName) {
        AntCorePreferences antPref = AntCorePlugin.getPlugin().getPreferences();
        String antHome = antPref.getAntHome();
        File etcDir = new File(antHome, ANT_XSL_DIR);
        if (etcDir.exists()) {
            return new File(etcDir, fileName);
        }
        return null;
    }
    
    public static Shell getShell() {
        IWorkbenchWindow window = getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }
    
    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = plugin.getWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }
    
}
