# CREATE TABLE `tablename` will be queried as
# CREATE TABLE `prefix_dirname_tablename`

CREATE TABLE `line_set` (
  id int unsigned NOT NULL auto_increment,
  image_id int unsigned NOT NULL,
  color int,
  `size` int,
  `alpha` int,
  PRIMARY KEY  (id),
  KEY image_id (image_id)
) TYPE=MyISAM;

CREATE TABLE `line` (
  id int unsigned NOT NULL auto_increment,
  image_id int unsigned NOT NULL,
  set_id int NOT NULL,
  fromx int NOT NULL default 0,
  fromy int NOT NULL default 0,
  tox int NOT NULL default 0,
  toy int NOT NULL default 0,
  PRIMARY KEY  (id),
  KEY set_id (set_id)
) TYPE=MyISAM;

CREATE TABLE `image` (
  id int unsigned NOT NULL auto_increment,
  code varchar(8) NOT NULL,
  width int NOT NULL,
  height int NOT NULL,
  `title` text default '',
  `desc` text default '',
  `type` int(1) NOT NULL,
  `view` int(11) NOT NULL default 0,
  `bookmark` int(11) NOT NULL default 0,
  `status` int(1) NOT NULL default 1,
  `paint_from_id` int(11) default NULL,
  `public_level` int not null default 1,
  `pasteok` int(1) not null default 1,
  `limit_level` int not null default 1,
  `tag_for_search` text not null default '',
  `guest_password` text default null,
  `exif` text default null,
  `camera_model` text default null,
  `time_limit` int(11) NOT NULL default '0',
  `upload_type` int(1) NOT NULL default '1',
  `ip_address` varchar(16) NOT NULL,
  reg_time int NOT NULL,
  reg_user int NOT NULL,
  mod_time int default NULL,
  mod_user int default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

CREATE TABLE `image_tmp` (
  id int unsigned NOT NULL auto_increment,
  code varchar(8) NOT NULL,
  width int NOT NULL,
  height int NOT NULL,
  `title` text default '',
  `desc` text default '',
  `type` int(1) NOT NULL,
  `view` int(11) NOT NULL default 0,
  `public_level` int not null default 1,
  `pasteok` int(1) not null default 1,
  `limit_level` int not null default 0,
  `upload_type` int(1) NOT NULL default '1',
  `ip_address` varchar(16) NOT NULL,
  `master_id` int unsigned NOT NULL,
  reg_time int NOT NULL,
  reg_user int NOT NULL,
  mod_time int default NULL,
  mod_user int default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

CREATE TABLE `tag` (
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL default '',
  `count` int(11) NOT NULL default '0',
  `limit_level` int(1) NOT NULL default '1',
  `hot_time` int(11) NOT NULL default '0',
  `reg_time` int(11) NOT NULL default '0',
  `reg_user` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM ;

CREATE TABLE `tag_image_link` (
  `id` int(11) NOT NULL auto_increment,
  `tag_id` int(11) NOT NULL default '0',
  `image_id` int(11) NOT NULL default '0',
  `lock` int(1) NOT NULL default '0',
  `limit_level` int(1) NOT NULL default '1',
  `reg_time` int(11) NOT NULL default '0',
  `reg_user` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM ;

CREATE TABLE `tool` (
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL default '',
  `order` int(11) NOT NULL default 10,
  `group` int(11) NOT NULL default 0,
  `reg_time` int(11) NOT NULL default '0',
  `mod_time` int(11) NOT NULL default '0',
  `reg_user` int(11) NOT NULL default '0',
  `mod_user` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM ;

CREATE TABLE `tool_image_link` (
  `id` int(11) NOT NULL auto_increment,
  `tool_id` int(11) NOT NULL default '0',
  `image_id` int(11) NOT NULL default '0',
  `reg_time` int(11) NOT NULL default '0',
  `reg_user` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM ;

CREATE TABLE `bookmark` (
  `id` int(11) NOT NULL auto_increment,
  `bookmark_list_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `image_id` int(11) NOT NULL,
  `reg_time` int(11) NOT NULL,
  `reg_user` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM ;

CREATE TABLE `bookmark_list` (
  `id` int(11) NOT NULL auto_increment,
  `name` TEXT NOT NULL default '',
  `desc` TEXT NOT NULL default '',
  `user_id` int(11) NOT NULL default '0',
  `public_level` int(1) NOT NULL default '1',
  `reg_time` int(11) NOT NULL default '0',
  `reg_user` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM ;

CREATE TABLE `comment` (
  `id` int(11) NOT NULL auto_increment,
  `disp_id` int(11) NOT NULL,
  `image_id` int(11) NOT NULL,
  `name` TEXT NOT NULL default '',
  `body` TEXT NOT NULL default '',
  `reg_time` int(11) NOT NULL default '0',
  `reg_user` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM ;

CREATE TABLE `access_count_daily` (
  `id` int(11) NOT NULL auto_increment,
  `image_id` int(11) NOT NULL,
  `count` int(11) NOT NULL default '0',
  `year` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `epoctime` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `year` (`year`),
  KEY `month` (`month`),
  KEY `day` (`day`)
) TYPE=MyISAM ;

CREATE TABLE `access_count_weekly` (
  `id` int(11) NOT NULL auto_increment,
  `image_id` int(11) NOT NULL,
  `count` int(11) NOT NULL default '0',
  `year` int(11) NOT NULL,
  `week` int(11) NOT NULL,
  `epoctime` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `year` (`year`),
  KEY `week` (`week`)
) TYPE=MyISAM ;

CREATE TABLE `access_count_monthly` (
  `id` int(11) NOT NULL auto_increment,
  `image_id` int(11) NOT NULL,
  `count` int(11) NOT NULL default '0',
  `year` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `epoctime` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `year` (`year`),
  KEY `month` (`month`)
) TYPE=MyISAM ;


