<?php

require_once XOOPS_ROOT_PATH.'/header.php';
require_once(dirname(dirname(__FILE__)) . '/include/groupperm_function.php');
require_once(dirname(dirname(__FILE__)) . '/include/misc.php');
require_once(dirname(dirname(__FILE__)) . '/include/db.php');

$constpref = strtoupper( $mydirname ) ;

spicky_main_css($mydirname);

if (is_object($xoopsUser)) {
	$user_id = $xoopsUser->getVar('uid');
} else {
	$user_id = 0;
}

$bookmarklist_list = spicky_get_bookmarklist_list($user_id);

if (count(@$bookmarklist_list) == 0) {
	$bookmark_list_id = spicky_add_bookmarklist(_MD_SPICKY_BOOKMARK_DFT_NAME, '', $user_id);
	$bookmarklist_list = spicky_get_bookmarklist_list($user_id);
}

if (isset($_GET['bookmark_list_id'])) {
	$bookmark_list_id = $_GET['bookmark_list_id'];
} else {
	$bookmark_list_id = $bookmarklist_list[0]['id'];
}

if (is_object($xoopsUser)) {
	$user_id = $xoopsUser->getVar('uid');
} else {
	$user_id = 0;
}

$gperm_super_user = spicky_checkright($mydirname, SPICKY_GPERM_SUPER_USER);

$bookmarklist = spicky_get_bookmarklist($bookmark_list_id);

if ($bookmarklist['public_level'] != 1) {
	if ($bookmarklist['user_id'] != $user_id && $gperm_super_user == 0) {
		// no right
		exit();
    }
}

$sort = isset($_GET['sort']) ? intval($_GET['sort']) : 1;
$bookmark_list = spicky_get_bookmark_list($bookmark_list_id, @$_GET['offset'], 100, $sort);

if ($_GET['viewer'] == 'autoviewer') {
	print '<?xml version="1.0" encoding="UTF-8"?>
	<gallery frameColor="0xFFFFFF" frameWidth="15" imagePadding="20" displayTime="6" enableRightClickOpen="true">' . "\n";
	foreach ($bookmark_list as $bookmark) {
		$ret = spicky_create_image_url($mydirname, $bookmark, 1280);

		if (@$ret['url'] == '') {
			continue;
		}

		print "<image>\n";
		print "		<url>" . $ret['url'] . "</url>\n";
		print "		<caption>" . mb_convert_encoding($bookmark['title'], 'utf-8', 'auto') . "</caption>\n";
		print "		<width>" . intval($ret['width']) . "</width>\n";
		print "		<height>" . intval($ret['height']) . "</height>\n";
		print "</image>\n";
	}
	print "</gallery>";
} else if ($_GET['viewer'] == 'tiltviewer') {
	print "<?xml version='1.0' encoding='UTF-8'?>\n";
	print "<tiltviewergallery>\n";
	print "	<photos>\n";
	foreach ($bookmark_list as $bookmark) {
		$ret = spicky_create_image_url($mydirname, $bookmark, 640);

		if (@$ret['url'] == '') {
			continue;
		}

		print "		<photo imageurl='" . $ret['url'] . "' >\n";
		print "		<title>" . mb_convert_encoding($bookmark['title'], 'utf-8', 'auto') . "</title>\n";
		print "		<description>" . mb_convert_encoding($bookmark['desc'], 'utf-8', 'auto') . "</description>\n";
		print "	</photo>\n";
	}
	print "	</photos>\n";
	print "</tiltviewergallery>\n";
} else {
	print '<?xml version="1.0" encoding="UTF-8"?>
	<channel>' . "\n";
	foreach ($bookmark_list as $bookmark) {
		$ret = spicky_create_image_url($mydirname, $bookmark, 1280);
		if (@$ret['url'] == '') {
			continue;
		}

		print "<item>\n";
		print "		<url>" . $ret['url'] . "</url>\n";
		print "		<caption>" . mb_convert_encoding($bookmark['title'], 'utf-8', 'auto') . "</caption>\n";
		print "</item>\n";
	}
	print "</channel>";
}

exit();


